/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.jetbrains.annotations.NotNull;

public class InMemoryDistributionPackage
implements DistributionPackage {
    private final String id;
    private final String type;
    private final long size;
    private final byte[] data;
    private final DistributionPackageInfo info;

    public InMemoryDistributionPackage(String id, String type, byte[] data) {
        this.id = id;
        this.type = type;
        this.data = data;
        this.size = data.length;
        this.info = new DistributionPackageInfo(type);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public InputStream createInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
    }

    @Override
    @NotNull
    public DistributionPackageInfo getInfo() {
        return this.info;
    }
}

