/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.transport.impl;

import java.net.URI;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.monitor.impl.UserCredentialsDistributionTransportSecretMBean;
import org.apache.sling.distribution.monitor.impl.UserCredentialsDistributionTransportSecretMBeanImpl;
import org.apache.sling.distribution.transport.DistributionTransportSecret;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, label="Apache Sling Distribution Transport Credentials - User Credentials based DistributionTransportSecretProvider", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionTransportSecretProvider.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Secret provider name: {name}"})
public class UserCredentialsDistributionTransportSecretProvider
implements DistributionTransportSecretProvider {
    @Property(label="Name")
    public static final String NAME = "name";
    @Property(label="User Name", description="The name of the user used to perform remote actions.")
    private static final String USERNAME = "username";
    @Property(label="Password", description="The clear text password to perform authentication. Warning: storing clear text passwords is not safe.")
    private static final String PASSWORD = "password";
    private String username;
    private String password;
    private ServiceRegistration mbeanServiceRegistration;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        this.username = PropertiesUtil.toString((Object)config.get(USERNAME), (String)"").trim();
        this.password = PropertiesUtil.toString((Object)config.get(PASSWORD), (String)"").trim();
        String id = String.valueOf(this.username.hashCode());
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling.distribution:type=transport,id=" + ObjectName.quote(id));
        UserCredentialsDistributionTransportSecretMBeanImpl mbean = new UserCredentialsDistributionTransportSecretMBeanImpl(this.username);
        this.mbeanServiceRegistration = context.registerService(UserCredentialsDistributionTransportSecretMBean.class.getName(), (Object)mbean, mbeanProps);
    }

    @Deactivate
    protected void deactivate() {
        if (this.mbeanServiceRegistration != null) {
            this.mbeanServiceRegistration.unregister();
        }
        this.mbeanServiceRegistration = null;
    }

    public DistributionTransportSecret getSecret(URI uri) {
        return new DistributionTransportSecret(){

            public Map<String, String> asCredentialsMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(UserCredentialsDistributionTransportSecretProvider.USERNAME, UserCredentialsDistributionTransportSecretProvider.this.username);
                map.put(UserCredentialsDistributionTransportSecretProvider.PASSWORD, UserCredentialsDistributionTransportSecretProvider.this.password);
                return Collections.unmodifiableMap(map);
            }
        };
    }
}

