/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/distribution/service/agent/queue"}, methods={"POST"})
public class DistributionAgentQueueServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private DistributionPackageBuilderProvider packageBuilderProvider;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String operation = request.getParameter("operation");
        DistributionQueue queue = (DistributionQueue)request.getResource().adaptTo(DistributionQueue.class);
        ResourceResolver resourceResolver = request.getResourceResolver();
        if ("delete".equals(operation)) {
            String limitParam = request.getParameter("limit");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null) {
                this.deleteItems(resourceResolver, queue, idParam);
            } else {
                int limit = 1;
                try {
                    limit = Integer.parseInt(limitParam);
                }
                catch (NumberFormatException ex) {
                    this.log.warn("limit param malformed : " + limitParam, (Throwable)ex);
                }
                this.deleteItems(resourceResolver, queue, limit);
            }
        } else if ("copy".equals(operation)) {
            String from = request.getParameter("from");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null && from != null) {
                DistributionAgent agent = (DistributionAgent)request.getResource().getParent().getParent().adaptTo(DistributionAgent.class);
                DistributionQueue sourceQueue = DistributionAgentQueueServlet.getQueueOrThrow(agent, from);
                this.addItems(resourceResolver, queue, sourceQueue, idParam);
            }
        } else if ("move".equals(operation)) {
            String from = request.getParameter("from");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null && from != null) {
                DistributionAgent agent = (DistributionAgent)request.getResource().getParent().getParent().adaptTo(DistributionAgent.class);
                DistributionQueue sourceQueue = DistributionAgentQueueServlet.getQueueOrThrow(agent, from);
                this.addItems(resourceResolver, queue, sourceQueue, idParam);
                this.deleteItems(resourceResolver, sourceQueue, idParam);
            }
        }
    }

    private void addItems(ResourceResolver resourceResolver, DistributionQueue targetQueue, DistributionQueue sourceQueue, String[] ids) {
        for (String id : ids) {
            DistributionQueueEntry entry = sourceQueue.getItem(id);
            if (entry == null) continue;
            targetQueue.add(entry.getItem());
            DistributionPackage distributionPackage = this.getPackage(resourceResolver, entry.getItem());
            DistributionPackageUtils.acquire(distributionPackage, targetQueue.getName());
        }
    }

    private void deleteItems(ResourceResolver resourceResolver, DistributionQueue queue, int limit) {
        for (DistributionQueueEntry item : queue.getItems(0, limit)) {
            this.deleteItem(resourceResolver, queue, item);
        }
    }

    private void deleteItems(ResourceResolver resourceResolver, DistributionQueue queue, String[] ids) {
        for (String id : ids) {
            DistributionQueueEntry entry = queue.getItem(id);
            this.deleteItem(resourceResolver, queue, entry);
        }
    }

    private void deleteItem(ResourceResolver resourceResolver, DistributionQueue queue, DistributionQueueEntry entry) {
        DistributionQueueItem item = entry.getItem();
        String id = entry.getId();
        queue.remove(id);
        DistributionPackage distributionPackage = this.getPackage(resourceResolver, item);
        DistributionPackageUtils.releaseOrDelete(distributionPackage, queue.getName());
    }

    private DistributionPackage getPackage(ResourceResolver resourceResolver, DistributionQueueItem item) {
        DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(item);
        String type = info.getType();
        DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(type);
        if (packageBuilder != null) {
            try {
                return packageBuilder.getPackage(resourceResolver, item.getPackageId());
            }
            catch (DistributionException e) {
                this.log.error("cannot get package", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static DistributionQueue getQueueOrThrow(@NotNull DistributionAgent agent, @NotNull String queueName) {
        DistributionQueue queue = agent.getQueue(queueName);
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Could not find queue %s", queueName));
        }
        return queue;
    }

    protected void bindPackageBuilderProvider(DistributionPackageBuilderProvider distributionPackageBuilderProvider) {
        this.packageBuilderProvider = distributionPackageBuilderProvider;
    }

    protected void unbindPackageBuilderProvider(DistributionPackageBuilderProvider distributionPackageBuilderProvider) {
        if (this.packageBuilderProvider == distributionPackageBuilderProvider) {
            this.packageBuilderProvider = null;
        }
    }
}

