/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.InMemoryDistributionPackage;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.serialization.DistributionExportFilter;
import org.apache.sling.distribution.serialization.DistributionExportOptions;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDistributionPackageBuilder
extends AbstractDistributionPackageBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionContentSerializer serializer;
    private final NavigableMap<String, List<String>> nodeFilters;
    private final NavigableMap<String, List<String>> propertyFilters;

    public InMemoryDistributionPackageBuilder(@NotNull String type, @NotNull DistributionContentSerializer serializer, @Nullable String[] nodeFilters, @Nullable String[] propertyFilters) {
        super(type);
        this.serializer = serializer;
        this.nodeFilters = VltUtils.parseFilters(nodeFilters);
        this.propertyFilters = VltUtils.parseFilters(propertyFilters);
    }

    @Override
    protected DistributionPackage createPackageForAdd(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.export(resourceResolver, request, baos);
        String packageId = "dstrpck-" + System.currentTimeMillis() + "-" + UUID.randomUUID().toString();
        return new InMemoryDistributionPackage(packageId, this.getType(), baos.toByteArray());
    }

    @Override
    protected DistributionPackage readPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        String packageId;
        HashMap<String, Object> info = new HashMap<String, Object>();
        DistributionPackageUtils.readInfo(stream, info);
        Object remoteId = info.get("remote.package.id");
        if (remoteId != null) {
            packageId = remoteId.toString();
            this.log.debug("preserving remote id {}", (Object)packageId);
        } else {
            packageId = "distrpck-read-" + System.nanoTime();
            this.log.debug("generating a new id {}", (Object)packageId);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)baos);
            baos.flush();
            byte[] data = baos.toByteArray();
            return new InMemoryDistributionPackage(packageId, this.getType(), data);
        }
        catch (IOException e) {
            throw new DistributionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean installPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull InputStream inputStream) throws DistributionException {
        try {
            this.serializer.importFromStream(resourceResolver, inputStream);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    protected DistributionPackage getPackageInternal(@NotNull ResourceResolver resourceResolver, @NotNull String id) {
        return null;
    }

    private void export(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request, @NotNull OutputStream outputStream) throws DistributionException {
        DistributionExportFilter filter = this.serializer.isRequestFiltering() ? null : DistributionExportFilter.createFilter(request, this.nodeFilters, this.propertyFilters);
        DistributionExportOptions distributionExportOptions = new DistributionExportOptions(request, filter);
        this.serializer.exportToStream(resourceResolver, distributionExportOptions, outputStream);
    }
}

