/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.AbstractDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionQueueProvider;
import org.apache.sling.distribution.monitor.impl.SyncDistributionAgentMBean;
import org.apache.sling.distribution.monitor.impl.SyncDistributionAgentMBeanImpl;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporter;
import org.apache.sling.distribution.queue.impl.ErrorQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.MultipleQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingDistributionQueueProvider;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Agent - Sync Agents Factory", description="OSGi configuration factory for syncing agents", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Reference(name="triggers", referenceInterface=DistributionTrigger.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindDistributionTrigger", unbind="unbindDistributionTrigger")
@Property(name="webconsole.configurationFactory.nameHint", value={"Agent name: {name}"})
public class SyncDistributionAgentFactory
extends AbstractDistributionAgentFactory<SyncDistributionAgentMBean> {
    @Property(label="Name", description="The name of the agent.")
    public static final String NAME = "name";
    @Property(label="Title", description="The display friendly title of the agent.")
    public static final String TITLE = "title";
    @Property(label="Details", description="The display friendly details of the agent.")
    public static final String DETAILS = "details";
    @Property(boolValue={true}, label="Enabled", description="Whether or not to start the distribution agent.")
    private static final String ENABLED = "enabled";
    @Property(label="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
    private static final String SERVICE_NAME = "serviceName";
    @Property(options={@PropertyOption(name="debug", value="debug"), @PropertyOption(name="info", value="info"), @PropertyOption(name="warn", value="warn"), @PropertyOption(name="error", value="error")}, value={"info"}, label="Log Level", description="The log level recorded in the transient log accessible via http.")
    public static final String LOG_LEVEL = "log.level";
    @Property(boolValue={true}, label="Queue Processing Enabled", description="Whether or not the distribution agent should process packages in the queues.")
    private static final String QUEUE_PROCESSING_ENABLED = "queue.processing.enabled";
    @Property(cardinality=100, label="Passive queues", description="List of queues that should be disabled.These queues will gather all the packages until they are removed explicitly.")
    private static final String PASSIVE_QUEUES = "passiveQueues";
    @Property(cardinality=100, label="Exporter Endpoints", description="List of endpoints from which packages are received (exported)")
    private static final String EXPORTER_ENDPOINTS = "packageExporter.endpoints";
    @Property(cardinality=100, label="Importer Endpoints", description="List of endpoints to which packages are sent (imported). The list can be given as a map in case a queue should be configured for each endpoint, e.g. queueName=http://...")
    private static final String IMPORTER_ENDPOINTS = "packageImporter.endpoints";
    @Property(options={@PropertyOption(name="none", value="none"), @PropertyOption(name="errorQueue", value="errorQueue")}, value={"none"}, label="Retry Strategy", description="The strategy to apply after a certain number of failed retries.")
    private static final String RETRY_STRATEGY = "retry.strategy";
    @Property(intValue={100}, label="Retry attempts", description="The number of times to retry until the retry strategy is applied.")
    private static final String RETRY_ATTEMPTS = "retry.attempts";
    @Property(intValue={100}, label="Pull Items", description="Number of subsequent pull requests to make.")
    private static final String PULL_ITEMS = "pull.items";
    @Property(label="HTTP connection timeout", intValue={10}, description="The connection timeout for HTTP requests (in seconds).")
    public static final String HTTP = "http.conn.timeout";
    @Reference
    private Packaging packaging;
    @Property(name="requestAuthorizationStrategy.target", label="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="requestAuthorizationStrategy")
    private DistributionRequestAuthorizationStrategy requestAuthorizationStrategy;
    @Property(name="transportSecretProvider.target", label="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    @Property(name="packageBuilder.target", label="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Property(value={"(name=)"}, label="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
    public static final String TRIGGERS_TARGET = "triggers.target";
    @Reference
    private DistributionEventFactory distributionEventFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository slingRepository;

    public SyncDistributionAgentFactory() {
        super(SyncDistributionAgentMBean.class);
    }

    @Override
    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        super.activate(context, config);
    }

    @Override
    protected void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.bindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    protected void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.unbindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext context) {
        super.deactivate(context);
    }

    @Override
    protected SimpleDistributionAgent createAgent(String agentName, BundleContext context, Map<String, Object> config, DefaultDistributionLog distributionLog) {
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        boolean queueProcessingEnabled = PropertiesUtil.toBoolean((Object)config.get(QUEUE_PROCESSING_ENABLED), (boolean)true);
        String[] passiveQueues = PropertiesUtil.toStringArray((Object)config.get(PASSIVE_QUEUES), (String[])new String[0]);
        passiveQueues = SettingsUtils.removeEmptyEntries(passiveQueues, new String[0]);
        Object exporterEndpointsValue = config.get(EXPORTER_ENDPOINTS);
        Object importerEndpointsValue = config.get(IMPORTER_ENDPOINTS);
        String[] exporterEndpoints = PropertiesUtil.toStringArray((Object)exporterEndpointsValue, (String[])new String[0]);
        exporterEndpoints = SettingsUtils.removeEmptyEntries(exporterEndpoints);
        Map<String, String> importerEndpointsMap = SettingsUtils.toUriMap(importerEndpointsValue);
        int pullItems = PropertiesUtil.toInteger((Object)config.get(PULL_ITEMS), (int)Integer.MAX_VALUE);
        ErrorQueueDispatchingStrategy importQueueStrategy = null;
        HashSet<String> processingQueues = new HashSet<String>();
        TreeSet<String> queuesMap = new TreeSet<String>();
        queuesMap.addAll(importerEndpointsMap.keySet());
        queuesMap.addAll(Arrays.asList(passiveQueues));
        processingQueues.addAll(importerEndpointsMap.keySet());
        processingQueues.removeAll(Arrays.asList(passiveQueues));
        String[] queueNames = queuesMap.toArray(new String[queuesMap.size()]);
        MultipleQueueDispatchingStrategy exportQueueStrategy = new MultipleQueueDispatchingStrategy(queueNames);
        Integer timeout = PropertiesUtil.toInteger((Object)HTTP, (int)10) * 1000;
        HttpConfiguration httpConfiguration = new HttpConfiguration(timeout);
        RemoteDistributionPackageImporter packageImporter = new RemoteDistributionPackageImporter(distributionLog, this.transportSecretProvider, importerEndpointsMap, httpConfiguration);
        RemoteDistributionPackageExporter packageExporter = new RemoteDistributionPackageExporter(distributionLog, this.packageBuilder, this.transportSecretProvider, exporterEndpoints, pullItems, httpConfiguration);
        MonitoringDistributionQueueProvider queueProvider = new MonitoringDistributionQueueProvider(new JobHandlingDistributionQueueProvider(agentName, this.jobManager, context), context);
        DistributionRequestType[] allowedRequests = new DistributionRequestType[]{DistributionRequestType.PULL};
        String retryStrategy = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(RETRY_STRATEGY), null));
        int retryAttepts = PropertiesUtil.toInteger((Object)config.get(RETRY_ATTEMPTS), (int)100);
        if ("errorQueue".equals(retryStrategy)) {
            importQueueStrategy = new ErrorQueueDispatchingStrategy(processingQueues.toArray(new String[processingQueues.size()]));
        }
        return new SimpleDistributionAgent(agentName, queueProcessingEnabled, processingQueues, serviceName, packageImporter, packageExporter, this.requestAuthorizationStrategy, queueProvider, exportQueueStrategy, importQueueStrategy, this.distributionEventFactory, this.resourceResolverFactory, this.slingRepository, distributionLog, allowedRequests, null, retryAttepts);
    }

    @Override
    protected SyncDistributionAgentMBean createMBeanAgent(DistributionAgent agent, Map<String, Object> osgiConfiguration) {
        return new SyncDistributionAgentMBeanImpl(agent, osgiConfiguration);
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy) {
        this.requestAuthorizationStrategy = distributionRequestAuthorizationStrategy;
    }

    protected void unbindRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy) {
        if (this.requestAuthorizationStrategy == distributionRequestAuthorizationStrategy) {
            this.requestAuthorizationStrategy = null;
        }
    }

    protected void bindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        this.transportSecretProvider = distributionTransportSecretProvider;
    }

    protected void unbindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        if (this.transportSecretProvider == distributionTransportSecretProvider) {
            this.transportSecretProvider = null;
        }
    }

    protected void bindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        this.packageBuilder = distributionPackageBuilder;
    }

    protected void unbindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        if (this.packageBuilder == distributionPackageBuilder) {
            this.packageBuilder = null;
        }
    }

    protected void bindDistributionEventFactory(DistributionEventFactory distributionEventFactory) {
        this.distributionEventFactory = distributionEventFactory;
    }

    protected void unbindDistributionEventFactory(DistributionEventFactory distributionEventFactory) {
        if (this.distributionEventFactory == distributionEventFactory) {
            this.distributionEventFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

