/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.util.impl;

import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionUtils {
    private static final Logger log = LoggerFactory.getLogger(DistributionUtils.class);
    private static final String AUTHENTICATION_INFO_SESSION = "user.jcr.credentials";

    public static ResourceResolver loginService(ResourceResolverFactory resolverFactory, String serviceName) throws LoginException {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        authInfo.put("sling.service.subservice", serviceName);
        return resolverFactory.getServiceResourceResolver(authInfo);
    }

    public static void safelyLogout(ResourceResolver resourceResolver) {
        try {
            if (resourceResolver != null) {
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                resourceResolver.close();
                if (session != null && session.isLive()) {
                    session.logout();
                }
            }
        }
        catch (Throwable t) {
            log.error("cannot safely close resource resolver {}", (Object)resourceResolver);
        }
    }

    public static void ungetResourceResolver(ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            try {
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (PersistenceException e) {
                log.error("cannot commit changes to resource resolver", (Throwable)e);
            }
            finally {
                DistributionUtils.safelyLogout(resourceResolver);
            }
        }
    }

    public static ResourceResolver getResourceResolver(String user, String service, SlingRepository slingRepository, String subServiceName, ResourceResolverFactory resourceResolverFactory) throws DistributionException {
        try {
            HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
            if (subServiceName == null && user != null) {
                try {
                    Session session = slingRepository.impersonateFromService(service, (Credentials)new SimpleCredentials(user, new char[0]), null);
                    authenticationInfo.put(AUTHENTICATION_INFO_SESSION, session);
                }
                catch (NoSuchMethodError nsme) {
                    log.warn("without sling.jcr.api 2.3.0 content will be aggregated using service {}", (Object)service);
                    Session session = slingRepository.loginService(service, null);
                    authenticationInfo.put(AUTHENTICATION_INFO_SESSION, session);
                }
            } else {
                authenticationInfo.put("sling.service.subservice", subServiceName);
            }
            ResourceResolver resourceResolver = resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
            return resourceResolver;
        }
        catch (LoginException le) {
            throw new DistributionException(le);
        }
        catch (RepositoryException re) {
            throw new DistributionException(re);
        }
    }
}

