/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.RemoteEventDistributionTrigger;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Remote Event Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name}"})
public class RemoteEventDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Endpoint", description="The endpoint from which the remote requests should be polled.")
    private static final String ENDPOINT = "endpoint";
    @Property(name="transportSecretProvider.target")
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    @Reference
    private Scheduler scheduler;
    private RemoteEventDistributionTrigger trigger;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        String endpoint = PropertiesUtil.toString((Object)config.get(ENDPOINT), null);
        this.trigger = new RemoteEventDistributionTrigger(endpoint, this.transportSecretProvider, this.scheduler);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    protected void bindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        this.transportSecretProvider = distributionTransportSecretProvider;
    }

    protected void unbindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        if (this.transportSecretProvider == distributionTransportSecretProvider) {
            this.transportSecretProvider = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

