/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.DistributionEndpoint;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteEventDistributionTrigger
implements DistributionTrigger {
    private static final String SCHEDULE_NAME = "remoteEventTrigger";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionEndpoint endpoint;
    private final DistributionTransportSecretProvider distributionTransportSecretProvider;
    private Scheduler scheduler;
    private final Map<DistributionRequestHandler, Future<HttpResponse>> requests = new ConcurrentHashMap<DistributionRequestHandler, Future<HttpResponse>>();

    public RemoteEventDistributionTrigger(String endpoint, DistributionTransportSecretProvider distributionTransportSecretProvider, Scheduler scheduler) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint is required");
        }
        if (distributionTransportSecretProvider == null) {
            throw new IllegalArgumentException("Authentication provider is required");
        }
        this.distributionTransportSecretProvider = distributionTransportSecretProvider;
        this.endpoint = new DistributionEndpoint(endpoint);
        this.scheduler = scheduler;
    }

    @Override
    public void register(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        try {
            this.log.info("applying remote event distribution trigger");
            ScheduleOptions options = this.scheduler.NOW();
            options.name(this.getJobName(requestHandler));
            options.canRunConcurrently(false);
            options.onLeaderOnly(true);
            this.scheduler.schedule((Object)new EventBasedDistribution(requestHandler), options);
        }
        catch (Exception e) {
            throw new DistributionException("unable to register handler " + requestHandler, e);
        }
    }

    @Override
    public void unregister(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        Future<HttpResponse> httpResponseFuture = this.requests.remove(requestHandler);
        if (httpResponseFuture != null) {
            httpResponseFuture.cancel(true);
        }
        this.scheduler.unschedule(this.getJobName(requestHandler));
    }

    private String getJobName(DistributionRequestHandler requestHandler) {
        return SCHEDULE_NAME + requestHandler.toString();
    }

    public void disable() {
        for (Map.Entry<DistributionRequestHandler, Future<HttpResponse>> entry : this.requests.entrySet()) {
            entry.getValue().cancel(true);
            this.scheduler.unschedule(this.getJobName(entry.getKey()));
        }
    }

    private class EventBasedDistribution
    implements Runnable {
        private final DistributionRequestHandler requestHandler;

        public EventBasedDistribution(DistributionRequestHandler requestHandler) {
            this.requestHandler = requestHandler;
        }

        @Override
        public void run() {
            block4: {
                try {
                    RemoteEventDistributionTrigger.this.log.debug("getting events from {}", (Object)RemoteEventDistributionTrigger.this.endpoint.getUri().toString());
                    RemoteEventDistributionTrigger.this.log.debug("preparing request");
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    Map credentialsMap = RemoteEventDistributionTrigger.this.distributionTransportSecretProvider.getSecret(RemoteEventDistributionTrigger.this.endpoint.getUri()).asCredentialsMap();
                    if (credentialsMap == null) break block4;
                    String username = (String)credentialsMap.get("username");
                    String password = (String)credentialsMap.get("password");
                    credentialsProvider.setCredentials(new AuthScope(new HttpHost(RemoteEventDistributionTrigger.this.endpoint.getUri().getHost(), RemoteEventDistributionTrigger.this.endpoint.getUri().getPort())), (Credentials)new UsernamePasswordCredentials(username, password));
                    CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
                    HttpGet get = new HttpGet(RemoteEventDistributionTrigger.this.endpoint.getUri());
                    HttpHost target = URIUtils.extractHost((URI)get.getURI());
                    BasicAsyncRequestProducer basicAsyncRequestProducer = new BasicAsyncRequestProducer(target, (HttpRequest)get);
                    httpClient.start();
                    try {
                        RemoteEventDistributionTrigger.this.log.debug("sending request");
                        Future futureResponse = httpClient.execute((HttpAsyncRequestProducer)basicAsyncRequestProducer, (HttpAsyncResponseConsumer)new SSEResponseConsumer(this.requestHandler), (FutureCallback)new FutureCallback<HttpResponse>(){

                            public void completed(HttpResponse httpResponse) {
                                RemoteEventDistributionTrigger.this.log.debug("response received {}", (Object)httpResponse);
                            }

                            public void failed(Exception e) {
                                RemoteEventDistributionTrigger.this.log.warn("failed request {}", (Object)e.toString());
                            }

                            public void cancelled() {
                                RemoteEventDistributionTrigger.this.log.warn("request cancelled");
                            }
                        });
                        RemoteEventDistributionTrigger.this.requests.put(this.requestHandler, futureResponse);
                        futureResponse.get();
                    }
                    catch (Exception e) {
                        RemoteEventDistributionTrigger.this.log.warn("cannot communicate with {}", (Object)RemoteEventDistributionTrigger.this.endpoint, (Object)e);
                    }
                    httpClient.close();
                    RemoteEventDistributionTrigger.this.log.debug("request finished");
                }
                catch (Exception e) {
                    RemoteEventDistributionTrigger.this.log.error("cannot run event based distribution {}", (Throwable)e);
                }
            }
        }
    }

    private class SSEResponseConsumer
    extends BasicAsyncResponseConsumer {
        private final DistributionRequestHandler handler;

        private SSEResponseConsumer(DistributionRequestHandler handler) {
            this.handler = handler;
        }

        protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            RemoteEventDistributionTrigger.this.log.debug("complete {}", (Object)decoder.isCompleted());
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            decoder.read(buffer);
            RemoteEventDistributionTrigger.this.log.debug("content {} received {},{}", new Object[]{buffer, decoder, ioctrl});
            SimpleDistributionRequest distributionRequest = new SimpleDistributionRequest(DistributionRequestType.PULL, new String[]{"/"});
            this.handler.handle(null, (DistributionRequest)distributionRequest);
            RemoteEventDistributionTrigger.this.log.info("distribution request to agent {} sent ({} {})", new Object[]{this.handler, distributionRequest.getRequestType(), distributionRequest.getPaths()});
            super.onContentReceived(decoder, ioctrl);
        }

        protected void onResponseReceived(HttpResponse response) throws IOException {
            RemoteEventDistributionTrigger.this.log.info("response received {}", (Object)response);
            super.onResponseReceived(response);
        }
    }
}

