/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.JcrEventDistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Jcr Event Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name} on path {path}"})
public class JcrEventDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Path", description="The path for which changes are distributed.")
    private static final String PATH = "path";
    @Property(cardinality=100, label="Ignored Paths Patterns", description="The paths matching one of these patterns will be ignored.")
    private static final String IGNORED_PATHS_PATTERNS = "ignoredPathsPatterns";
    @Property(label="Service Name", description="The service used to listen for jcr events")
    private static final String SERVICE_NAME = "serviceName";
    @Property(label="Use deep distribution", description="Distribute entire subtree of the event node path", boolValue={false})
    private static final String DEEP = "deep";
    private JcrEventDistributionTrigger trigger;
    @Reference
    private SlingRepository repository;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    public void activate(Map<String, Object> config) {
        String path = PropertiesUtil.toString((Object)config.get(PATH), null);
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        String[] ignoredPathsPatterns = PropertiesUtil.toStringArray((Object)config.get(IGNORED_PATHS_PATTERNS), null);
        ignoredPathsPatterns = SettingsUtils.removeEmptyEntries(ignoredPathsPatterns);
        boolean deep = PropertiesUtil.toBoolean((Object)config.get(DEEP), (boolean)false);
        this.trigger = new JcrEventDistributionTrigger(this.repository, this.scheduler, this.resolverFactory, path, deep, serviceName, ignoredPathsPatterns);
        this.trigger.enable();
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

