/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.DistributionEventDistributeDistributionTrigger;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Distribution Event Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name}"})
public class DistributionEventDistributeDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Path", description="The path for which the distribution events will be forwarded.")
    private static final String PATH = "path";
    private DistributionEventDistributeDistributionTrigger trigger;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        String path = PropertiesUtil.toString((Object)config.get(PATH), null);
        this.trigger = new DistributionEventDistributeDistributionTrigger(path, bundleContext);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }
}

