/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionEventDistributeDistributionTrigger
implements DistributionTrigger {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String pathPrefix;
    private final BundleContext bundleContext;
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();

    public DistributionEventDistributeDistributionTrigger(String pathPrefix, BundleContext bundleContext) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException("path is required");
        }
        this.bundleContext = bundleContext;
        this.pathPrefix = pathPrefix;
    }

    @Override
    public void register(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/apache/sling/distribution/agent/package/distributed");
        this.log.info("handler {} will chain distribute on path '{}'", (Object)requestHandler, (Object)this.pathPrefix);
        if (this.bundleContext != null) {
            ServiceRegistration triggerPathEventRegistration = this.bundleContext.registerService(EventHandler.class.getName(), (Object)new TriggerAgentEventListener(requestHandler, this.pathPrefix), properties);
            if (triggerPathEventRegistration != null) {
                this.registrations.put(requestHandler.toString(), triggerPathEventRegistration);
            }
        } else {
            throw new DistributionException("cannot register trigger since bundle context is null");
        }
    }

    @Override
    public void unregister(@Nonnull DistributionRequestHandler requestHandler) throws DistributionException {
        ServiceRegistration serviceRegistration = this.registrations.get(requestHandler.toString());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public void disable() {
        for (Map.Entry<String, ServiceRegistration> entry : this.registrations.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().unregister();
        }
        this.registrations.clear();
    }

    private class TriggerAgentEventListener
    implements EventHandler {
        private final DistributionRequestHandler requestHandler;
        private final String path;

        public TriggerAgentEventListener(DistributionRequestHandler requestHandler, String path) {
            this.requestHandler = requestHandler;
            this.path = path;
        }

        public void handleEvent(Event event) {
            Object actionProperty = event.getProperty("distribution.type");
            Object pathProperty = event.getProperty("distribution.paths");
            if (actionProperty != null && pathProperty != null) {
                String[] paths;
                for (String p : paths = (String[])pathProperty) {
                    if (!p.startsWith(this.path)) continue;
                    DistributionEventDistributeDistributionTrigger.this.log.info("triggering chain distribution from event {}", (Object)event);
                    DistributionRequestType action = DistributionRequestType.valueOf((String)String.valueOf(actionProperty));
                    this.requestHandler.handle(null, (DistributionRequest)new SimpleDistributionRequest(action, paths));
                    break;
                }
            }
        }
    }
}

