/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.distribution.DistributionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletJsonUtils {
    private static final Logger log = LoggerFactory.getLogger(ServletJsonUtils.class);

    ServletJsonUtils() {
    }

    public static void writeJson(SlingHttpServletResponse response, DistributionResponse distributionResponse) throws IOException {
        JsonObjectBuilder json = Json.createObjectBuilder();
        try {
            json.add("success", distributionResponse.isSuccessful());
            json.add("state", distributionResponse.getState().name());
            json.add("message", distributionResponse.getMessage());
        }
        catch (JsonException e) {
            log.error("Cannot write json", (Throwable)e);
        }
        switch (distributionResponse.getState()) {
            case DISTRIBUTED: {
                response.setStatus(200);
                break;
            }
            case DROPPED: {
                response.setStatus(400);
                break;
            }
            case ACCEPTED: {
                response.setStatus(202);
                break;
            }
        }
        ServletJsonUtils.append(json.build(), response.getWriter());
    }

    public static void writeJson(SlingHttpServletResponse response, int status, String message, @Nullable Map<String, String> kv) throws IOException {
        JsonObjectBuilder json = Json.createObjectBuilder();
        try {
            json.add("message", message);
            if (kv != null && kv.size() > 0) {
                for (Map.Entry<String, String> entry : kv.entrySet()) {
                    json.add(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (JsonException e) {
            log.error("Cannot write json", (Throwable)e);
        }
        response.setStatus(status);
        ServletJsonUtils.append(json.build(), response.getWriter());
    }

    private static void append(JsonObject json, Writer writer) throws IOException {
        StringWriter buffer = new StringWriter();
        Json.createWriter((Writer)buffer).writeObject(json);
        writer.append(buffer.toString());
    }
}

