/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.servlet.ServletJsonUtils;
import org.apache.sling.distribution.util.impl.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/distribution/service/importer"}, methods={"POST"})
public class DistributionPackageImporterServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DIGEST_HEADER = "Digest";
    private final Pattern digestHeaderRegex = Pattern.compile("(MD[25]|SHA-(?:1|256|384|512))=([a-fA-F0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        DistributionPackageImporter distributionPackageImporter = (DistributionPackageImporter)request.getResource().adaptTo(DistributionPackageImporter.class);
        String digestAlgorithm = null;
        String digestMessage = null;
        String digestHeader = request.getHeader(DIGEST_HEADER);
        if (DistributionPackageImporterServlet.isNotEmpty(digestHeader)) {
            this.log.debug("Found Digest header {}, extracting algorithm and message...", (Object)digestHeader);
            Matcher matcher = this.digestHeaderRegex.matcher(digestHeader);
            if (matcher.matches()) {
                digestAlgorithm = matcher.group(1);
                digestMessage = matcher.group(2);
            } else {
                this.log.debug("Digest header {} not supported, it doesn't match with expected pattern {}", new Object[]{digestHeader, this.digestHeaderRegex.pattern()});
            }
        }
        long start = System.currentTimeMillis();
        response.setContentType("application/json");
        Object stream = DistributionPackageImporterServlet.isNotEmpty(digestAlgorithm) && DistributionPackageImporterServlet.isNotEmpty(digestMessage) ? DigestUtils.openDigestInputStream((InputStream)request.getInputStream(), digestAlgorithm) : request.getInputStream();
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            String receivedDigestMessage;
            if (request.getParameter("forceError") != null) {
                throw new Exception("manually forced error");
            }
            DistributionPackageInfo distributionPackageInfo = distributionPackageImporter.importStream(resourceResolver, (InputStream)stream);
            long end = System.currentTimeMillis();
            if (DistributionPackageImporterServlet.isNotEmpty(digestAlgorithm) && DistributionPackageImporterServlet.isNotEmpty(digestMessage) && !digestMessage.equalsIgnoreCase(receivedDigestMessage = DigestUtils.readDigestMessage((DigestInputStream)stream))) {
                this.log.error("Error during distribution import: received distribution package is corrupted, expected [{}] but received [{}]", new Object[]{digestMessage, receivedDigestMessage});
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put("digestAlgorithm", digestAlgorithm);
                kv.put("expected", digestMessage);
                kv.put("received", receivedDigestMessage);
                ServletJsonUtils.writeJson(response, 400, "Received distribution package is corrupted", kv);
                return;
            }
            this.log.info("Package {} imported successfully in {}ms", (Object)distributionPackageInfo, (Object)(end - start));
            ServletJsonUtils.writeJson(response, 200, "package imported successfully", null);
        }
        catch (Throwable e) {
            ServletJsonUtils.writeJson(response, 500, "an unexpected error has occurred during distribution import", null);
            this.log.error("Error during distribution import", e);
        }
        finally {
            long end = System.currentTimeMillis();
            this.log.debug("Processed package import request in {} ms", (Object)(end - start));
        }
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }
}

