/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.log.DistributionLog;
import org.apache.sling.distribution.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/distribution/service/log"}, methods={"GET"}, extensions={"txt"})
public class DistributionAgentLogServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        DistributionRequest distributionRequest = RequestUtils.fromServletRequest((HttpServletRequest)request);
        this.log.debug("distribution request : {}", (Object)distributionRequest);
        DistributionLog distributionLog = (DistributionLog)request.getResource().adaptTo(DistributionLog.class);
        PrintWriter writer = response.getWriter();
        if (distributionLog != null) {
            for (String line : distributionLog.getLines()) {
                writer.append(line);
                writer.append("\n");
            }
        } else {
            response.setStatus(404);
            writer.append("agent not found");
        }
    }
}

