/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl.vlt;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.FileDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageCleanup;
import org.apache.sling.distribution.serialization.impl.vlt.FileVaultContentSerializer;
import org.apache.sling.distribution.util.impl.FileBackedMemoryOutputStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, label="Apache Sling Distribution Packaging - Vault Package Builder Factory", description="OSGi configuration for vault package builders", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageBuilder.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Builder name: {name}"})
public class VaultDistributionPackageBuilderFactory
implements DistributionPackageBuilder {
    @Property(label="Name", description="The name of the package builder.")
    private static final String NAME = "name";
    @Property(options={@PropertyOption(name="jcrvlt", value="jcr packages"), @PropertyOption(name="filevlt", value="file packages")}, value={"jcrvlt"}, label="type", description="The type of this package builder")
    private static final String TYPE = "type";
    @Property(label="Import Mode", description="The vlt import mode for created packages.")
    private static final String IMPORT_MODE = "importMode";
    @Property(label="Acl Handling", description="The vlt acl handling mode for created packages.")
    private static final String ACL_HANDLING = "aclHandling";
    @Property(label="Package Roots", description="The package roots to be used for created packages. (this is useful for assembling packages with an user that cannot read above the package root)")
    private static final String PACKAGE_ROOTS = "package.roots";
    @Property(label="Package Node Filters", description="The package node path filters. Filter format: path|+include|-exclude", cardinality=100)
    private static final String PACKAGE_FILTERS = "package.filters";
    @Property(label="Package Property Filters", description="The package property path filters. Filter format: path|+include|-exclude", unbounded=PropertyUnbounded.ARRAY, value={})
    private static final String PROPERTY_FILTERS = "property.filters";
    @Property(label="Temp Filesystem Folder", description="The filesystem folder where the temporary files should be saved.")
    private static final String TEMP_FS_FOLDER = "tempFsFolder";
    @Property(label="Use Binary References", description="If activated, it avoids sending binaries in the distribution package.", boolValue={false})
    public static final String USE_BINARY_REFERENCES = "useBinaryReferences";
    @Property(label="Autosave threshold", description="The value after which autosave is triggered for intermediate changes.", intValue={-1})
    public static final String AUTOSAVE_THRESHOLD = "autoSaveThreshold";
    private static final long DEFAULT_PACKAGE_CLEANUP_DELAY = 60L;
    @Property(label="The delay in seconds between two runs of the cleanup phase for resource persisted packages.", description="The resource persisted packages are cleaned up periodically (asynchronously) since SLING-6503.The delay between two runs of the cleanup phase can be configured with this setting. 60 seconds by default", longValue={60L})
    private static final String PACKAGE_CLEANUP_DELAY = "cleanupDelay";
    private static final int DEFAULT_FILE_THRESHOLD_VALUE = 1;
    @Property(label="File threshold (in bytes)", description="Once the data reaches the configurable size value, buffering to memory switches to file buffering.", intValue={1})
    public static final String FILE_THRESHOLD = "fileThreshold";
    private static final String DEFAULT_MEMORY_UNIT = "MEGA_BYTES";
    @Property(label="The memory unit for the file threshold", description="The memory unit for the file threshold, Megabytes by default", value={"MEGA_BYTES"}, options={@PropertyOption(name="BYTES", value="Bytes"), @PropertyOption(name="KILO_BYTES", value="Kilobytes"), @PropertyOption(name="MEGA_BYTES", value="Megabytes"), @PropertyOption(name="GIGA_BYTES", value="Gigabytes")})
    private static final String MEMORY_UNIT = "MEGA_BYTES";
    private static final boolean DEFAULT_USE_OFF_HEAP_MEMORY = false;
    @Property(label="Flag to enable/disable the off-heap memory", description="Flag to enable/disable the off-heap memory, false by default", boolValue={false})
    public static final String USE_OFF_HEAP_MEMORY = "useOffHeapMemory";
    private static final String DEFAULT_DIGEST_ALGORITHM = "NONE";
    @Property(label="The digest algorithm to calculate the package checksum", description="The digest algorithm to calculate the package checksum, Megabytes by default", value={"NONE"}, options={@PropertyOption(name="NONE", value="Do not send digest"), @PropertyOption(name="MD2", value="md2"), @PropertyOption(name="MD5", value="md5"), @PropertyOption(name="SHA-1", value="sha1"), @PropertyOption(name="SHA-256", value="sha256"), @PropertyOption(name="SHA-384", value="sha384"), @PropertyOption(name="SHA-512", value="sha512")})
    private static final String DIGEST_ALGORITHM = "digestAlgorithm";
    private static final int DEFAULT_MONITORING_QUEUE_SIZE = 0;
    @Property(label="The number of items for monitoring distribution packages creation/installation", description="The number of items for monitoring distribution packages creation/installation, 100 by default", intValue={0})
    private static final String MONITORING_QUEUE_SIZE = "monitoringQueueSize";
    @Reference
    private Packaging packaging;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ServiceRegistration packageCleanup = null;
    private MonitoringDistributionPackageBuilder packageBuilder;

    @Activate
    public void activate(BundleContext context, Map<String, Object> config) {
        AbstractDistributionPackageBuilder wrapped;
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        String type = PropertiesUtil.toString((Object)config.get(TYPE), null);
        String importModeString = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(IMPORT_MODE), null));
        String aclHandlingString = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(ACL_HANDLING), null));
        String[] packageRoots = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)config.get(PACKAGE_ROOTS), null));
        String[] packageNodeFilters = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)config.get(PACKAGE_FILTERS), null));
        String[] packagePropertyFilters = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)config.get(PROPERTY_FILTERS), null));
        long cleanupDelay = PropertiesUtil.toLong((Object)config.get(PACKAGE_CLEANUP_DELAY), (long)60L);
        String tempFsFolder = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(TEMP_FS_FOLDER), null));
        boolean useBinaryReferences = PropertiesUtil.toBoolean((Object)config.get(USE_BINARY_REFERENCES), (boolean)false);
        int autosaveThreshold = PropertiesUtil.toInteger((Object)config.get(AUTOSAVE_THRESHOLD), (int)-1);
        String digestAlgorithm = PropertiesUtil.toString((Object)config.get(DIGEST_ALGORITHM), (String)DEFAULT_DIGEST_ALGORITHM);
        if (DEFAULT_DIGEST_ALGORITHM.equals(digestAlgorithm)) {
            digestAlgorithm = null;
        }
        ImportMode importMode = null;
        if (importModeString != null) {
            importMode = ImportMode.valueOf((String)importModeString.trim());
        }
        AccessControlHandling aclHandling = null;
        if (aclHandlingString != null) {
            aclHandling = AccessControlHandling.valueOf((String)aclHandlingString.trim());
        }
        FileVaultContentSerializer contentSerializer = new FileVaultContentSerializer(name, this.packaging, importMode, aclHandling, packageRoots, packageNodeFilters, packagePropertyFilters, useBinaryReferences, autosaveThreshold);
        if ("filevlt".equals(type)) {
            wrapped = new FileDistributionPackageBuilder(name, contentSerializer, tempFsFolder, digestAlgorithm, packageNodeFilters, packagePropertyFilters);
        } else {
            int fileThreshold = PropertiesUtil.toInteger((Object)config.get(FILE_THRESHOLD), (int)1);
            String memoryUnitName = PropertiesUtil.toString((Object)config.get("MEGA_BYTES"), (String)"MEGA_BYTES");
            FileBackedMemoryOutputStream.MemoryUnit memoryUnit = FileBackedMemoryOutputStream.MemoryUnit.valueOf(memoryUnitName);
            boolean useOffHeapMemory = PropertiesUtil.toBoolean((Object)config.get(USE_OFF_HEAP_MEMORY), (boolean)false);
            ResourceDistributionPackageBuilder resourceDistributionPackageBuilder = new ResourceDistributionPackageBuilder(contentSerializer.getName(), contentSerializer, tempFsFolder, fileThreshold, memoryUnit, useOffHeapMemory, digestAlgorithm, packageNodeFilters, packagePropertyFilters);
            ResourceDistributionPackageCleanup cleanup = new ResourceDistributionPackageCleanup(this.resolverFactory, resourceDistributionPackageBuilder);
            Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
            ((Dictionary)props).put("scheduler.concurrent", false);
            ((Dictionary)props).put("scheduler.period", cleanupDelay);
            this.packageCleanup = context.registerService(Runnable.class.getName(), (Object)cleanup, props);
            wrapped = resourceDistributionPackageBuilder;
        }
        int monitoringQueueSize = PropertiesUtil.toInteger((Object)config.get(MONITORING_QUEUE_SIZE), (int)0);
        this.packageBuilder = new MonitoringDistributionPackageBuilder(monitoringQueueSize, wrapped, context);
    }

    @Deactivate
    public void deactivate() {
        this.packageBuilder.clear();
        if (this.packageCleanup != null) {
            this.packageCleanup.unregister();
        }
    }

    @Override
    public String getType() {
        return this.packageBuilder.getType();
    }

    @Override
    @Nonnull
    public DistributionPackage createPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest request) throws DistributionException {
        return this.packageBuilder.createPackage(resourceResolver, request);
    }

    @Override
    @Nonnull
    public DistributionPackage readPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        return this.packageBuilder.readPackage(resourceResolver, stream);
    }

    @Override
    @CheckForNull
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String id) throws DistributionException {
        return this.packageBuilder.getPackage(resourceResolver, id);
    }

    @Override
    public boolean installPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionPackage distributionPackage) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, distributionPackage);
    }

    @Override
    @Nonnull
    public DistributionPackageInfo installPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, stream);
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

