/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl.vlt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.impl.FileDistributionPackage;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.serialization.DistributionExportOptions;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.util.DistributionJcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileVaultContentSerializer
implements DistributionContentSerializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TYPE = "filevault";
    private static final String VERSION = "0.0.1";
    private static final String PACKAGE_GROUP = "sling/distribution";
    private final Packaging packaging;
    private final ImportMode importMode;
    private final AccessControlHandling aclHandling;
    private final String[] packageRoots;
    private final int autosaveThreshold;
    private final TreeMap<String, List<String>> nodeFilters;
    private final TreeMap<String, List<String>> propertyFilters;
    private final boolean useBinaryReferences;
    private final String name;

    public FileVaultContentSerializer(String name, Packaging packaging, ImportMode importMode, AccessControlHandling aclHandling, String[] packageRoots, String[] nodeFilters, String[] propertyFilters, boolean useBinaryReferences, int autosaveThreshold) {
        this.name = name;
        this.packaging = packaging;
        this.importMode = importMode;
        this.aclHandling = aclHandling;
        this.packageRoots = packageRoots;
        this.autosaveThreshold = autosaveThreshold;
        this.nodeFilters = VltUtils.parseFilters(nodeFilters);
        this.propertyFilters = VltUtils.parseFilters(propertyFilters);
        this.useBinaryReferences = useBinaryReferences;
    }

    @Override
    public void exportToStream(ResourceResolver resourceResolver, DistributionExportOptions exportOptions, OutputStream outputStream) throws DistributionException {
        Session session = null;
        try {
            session = this.getSession(resourceResolver);
            String packageGroup = PACKAGE_GROUP;
            String packageName = "filevault_" + System.currentTimeMillis() + "_" + UUID.randomUUID();
            WorkspaceFilter filter = VltUtils.createFilter(exportOptions.getRequest(), this.nodeFilters, this.propertyFilters);
            ExportOptions opts = VltUtils.getExportOptions(filter, this.packageRoots, packageGroup, packageName, VERSION, this.useBinaryReferences);
            this.log.debug("assembling package {} user {}", (Object)(packageGroup + '/' + packageName + "-" + VERSION), (Object)resourceResolver.getUserID());
            this.packaging.getPackageManager().assemble(session, opts, outputStream);
        }
        catch (Exception e) {
            throw new DistributionException(e);
        }
        finally {
            this.ungetSession(session);
        }
    }

    @Override
    public void importFromStream(ResourceResolver resourceResolver, InputStream inputStream) throws DistributionException {
        Session session = null;
        BufferedOutputStream outputStream = null;
        File file = null;
        boolean isTmp = true;
        try {
            session = this.getSession(resourceResolver);
            ImportOptions importOptions = VltUtils.getImportOptions(this.aclHandling, this.importMode, this.autosaveThreshold);
            if (inputStream instanceof FileDistributionPackage.PackageInputStream) {
                file = ((FileDistributionPackage.PackageInputStream)inputStream).getFile();
                isTmp = false;
            } else {
                file = File.createTempFile("distrpck-tmp-" + System.nanoTime(), ".filevault");
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            PackageManager packageManager = this.packaging.getPackageManager();
            VaultPackage vaultPackage = packageManager.open(file);
            vaultPackage.extract(session, importOptions);
            vaultPackage.close();
        }
        catch (Exception e) {
            try {
                throw new DistributionException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                if (isTmp) {
                    FileUtils.deleteQuietly(file);
                }
                this.ungetSession(session);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (isTmp) {
            FileUtils.deleteQuietly((File)file);
        }
        this.ungetSession(session);
    }

    private Session getSession(ResourceResolver resourceResolver) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new RepositoryException("could not obtain a session from calling user " + resourceResolver.getUserID());
        }
        DistributionJcrUtils.setDoNotDistribute(session);
        return session;
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
            catch (RepositoryException e) {
                this.log.error("Cannot save session", (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRequestFiltering() {
        return true;
    }
}

