/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleDistributionQueueCheckpoint
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributionQueueCheckpoint.class);
    private final DistributionQueue queue;
    private final File checkpointDirectory;

    public SimpleDistributionQueueCheckpoint(DistributionQueue queue, File checkpointDirectory) {
        this.queue = queue;
        this.checkpointDirectory = checkpointDirectory;
    }

    @Override
    public void run() {
        String fileName = this.queue.getName() + "-checkpoint";
        File checkpointFile = new File(this.checkpointDirectory, fileName + "-new");
        log.debug("started checkpointing");
        try {
            if (checkpointFile.exists()) assert (checkpointFile.delete());
            assert (checkpointFile.createNewFile());
            LinkedList<String> lines = new LinkedList<String>();
            FileOutputStream fileOutputStream = new FileOutputStream(checkpointFile);
            for (DistributionQueueEntry queueEntry : this.queue.getItems(0, -1)) {
                DistributionQueueItem item = queueEntry.getItem();
                String packageId = item.getPackageId();
                StringWriter w = new StringWriter();
                JsonGenerator jsonWriter = Json.createGenerator((Writer)w);
                jsonWriter.writeStartObject();
                for (Map.Entry entry : item.entrySet()) {
                    Object value = entry.getValue();
                    boolean isArray = value instanceof String[];
                    if (isArray) {
                        jsonWriter.writeStartArray((String)entry.getKey());
                        for (String s : (String[])value) {
                            jsonWriter.write(s);
                        }
                        jsonWriter.writeEnd();
                        continue;
                    }
                    jsonWriter.write((String)entry.getKey(), (String)value);
                }
                jsonWriter.writeEnd();
                jsonWriter.close();
                lines.add(packageId + " " + w.toString());
            }
            log.debug("parsed {} items", (Object)lines.size());
            IOUtils.writeLines(lines, (String)Charset.defaultCharset().name(), (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
            fileOutputStream.flush();
            fileOutputStream.close();
            boolean success = checkpointFile.renameTo(new File(this.checkpointDirectory, fileName));
            log.debug("checkpoint succeeded: {}", (Object)success);
        }
        catch (Exception e) {
            log.error("failed checkpointing for queue {}", (Object)this.queue.getName());
        }
    }
}

