/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDistributionQueue
implements DistributionQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final Queue<DistributionQueueItem> queue;
    private final Map<DistributionQueueItem, DistributionQueueItemStatus> statusMap;

    public SimpleDistributionQueue(String agentName, String name) {
        this.log.debug("starting a simple queue {} for agent {}", (Object)name, (Object)agentName);
        this.name = name;
        this.queue = new LinkedBlockingQueue<DistributionQueueItem>();
        this.statusMap = new WeakHashMap<DistributionQueueItem, DistributionQueueItemStatus>(10);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributionQueueEntry add(@Nonnull DistributionQueueItem item) {
        DistributionQueueItemState itemState = DistributionQueueItemState.ERROR;
        boolean result = false;
        try {
            result = this.queue.offer(item);
            itemState = DistributionQueueItemState.QUEUED;
        }
        catch (Exception e) {
            this.log.error("cannot add an item to the queue", (Throwable)e);
        }
        finally {
            this.statusMap.put(item, new DistributionQueueItemStatus(Calendar.getInstance(), itemState, 0, this.name));
        }
        if (result) {
            return new DistributionQueueEntry(item.getPackageId(), item, this.statusMap.get((Object)item));
        }
        return null;
    }

    @Override
    @CheckForNull
    public DistributionQueueEntry getHead() {
        DistributionQueueItem element = this.queue.peek();
        if (element != null) {
            DistributionQueueItemStatus itemState = this.statusMap.get((Object)element);
            this.statusMap.put(element, new DistributionQueueItemStatus(itemState.getEntered(), itemState.getItemState(), itemState.getAttempts() + 1, this.name));
            return new DistributionQueueEntry(element.getPackageId(), element, itemState);
        }
        return null;
    }

    @Nonnull
    private DistributionQueueState getState() {
        DistributionQueueItem firstItem = this.queue.peek();
        DistributionQueueItemStatus firstItemStatus = firstItem != null ? this.statusMap.get((Object)firstItem) : null;
        return DistributionQueueUtils.calculateState(firstItem, firstItemStatus);
    }

    @Override
    @Nonnull
    public DistributionQueueStatus getStatus() {
        return new DistributionQueueStatus(this.queue.size(), this.getState());
    }

    @Override
    public DistributionQueueType getType() {
        return DistributionQueueType.ORDERED;
    }

    @Override
    @Nonnull
    public Iterable<DistributionQueueEntry> getItems(int skip, int limit) {
        ArrayList<DistributionQueueEntry> result = new ArrayList<DistributionQueueEntry>();
        for (DistributionQueueItem item : this.queue) {
            result.add(new DistributionQueueEntry(item.getPackageId(), item, this.statusMap.get((Object)item)));
        }
        return result;
    }

    @Override
    @CheckForNull
    public DistributionQueueEntry getItem(@Nonnull String id) {
        for (DistributionQueueItem item : this.queue) {
            if (!id.equals(item.getPackageId())) continue;
            return new DistributionQueueEntry(id, item, this.statusMap.get((Object)item));
        }
        return null;
    }

    @Override
    @CheckForNull
    public DistributionQueueEntry remove(@Nonnull String id) {
        DistributionQueueEntry toRemove = this.getItem(id);
        boolean removed = false;
        if (toRemove != null) {
            removed = this.queue.remove((Object)toRemove.getItem());
        }
        this.log.debug("item with id {} removed from the queue: {}", (Object)id, (Object)removed);
        if (removed) {
            return toRemove;
        }
        return null;
    }

    public String toString() {
        return "SimpleDistributionQueue{name='" + this.name + '\'' + '}';
    }
}

