/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.jobhandling;

import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingUtils;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistributionAgentJobConsumer
implements JobConsumer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionQueueProcessor queueProcessor;

    public DistributionAgentJobConsumer(DistributionQueueProcessor queueProcessor) {
        this.queueProcessor = queueProcessor;
    }

    public JobConsumer.JobResult process(Job job) {
        this.log.debug("processing job {}", (Object)job.getId());
        DistributionQueueEntry entry = JobHandlingUtils.getEntry(job);
        boolean processingResult = false;
        if (entry != null) {
            String queueName = entry.getStatus().getQueueName();
            this.log.debug("processing item {} in queue {}", (Object)entry.getId(), (Object)queueName);
            processingResult = this.queueProcessor.process(queueName, entry);
            this.log.debug("item {} processed {}", (Object)entry.getId());
        } else {
            this.log.warn("no entry for job {}", (Object)job.getId());
        }
        return processingResult ? JobConsumer.JobResult.OK : JobConsumer.JobResult.FAILED;
    }
}

