/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import javax.annotation.Nonnull;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueWrapper;

public class SimpleAgentDistributionQueue
extends DistributionQueueWrapper {
    private final boolean isPaused;
    private final String agentName;

    public SimpleAgentDistributionQueue(DistributionQueue wrappedQueue, boolean isPaused, String agentName) {
        super(wrappedQueue);
        this.isPaused = isPaused;
        this.agentName = agentName;
    }

    @Override
    @Nonnull
    public DistributionQueueStatus getStatus() {
        return this.calculateStatus();
    }

    @Override
    public DistributionQueueType getType() {
        return this.wrappedQueue.getType();
    }

    public String getAgentName() {
        return this.agentName;
    }

    private DistributionQueueStatus calculateStatus() {
        DistributionQueueStatus status = super.getStatus();
        if (this.isPaused) {
            return new DistributionQueueStatus(status.getItemsCount(), DistributionQueueState.PAUSED);
        }
        return status;
    }
}

