/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.MultipleQueueDispatchingStrategy;

public class PriorityQueueDispatchingStrategy
implements DistributionQueueDispatchingStrategy {
    private final Map<String, String> selectors;
    private final List<String> mainQueues;
    private final List<String> allQueues = new ArrayList<String>();

    public PriorityQueueDispatchingStrategy(Map<String, String> selectors, String[] queueNames) {
        this.selectors = selectors;
        this.mainQueues = Arrays.asList(queueNames);
        Map<String, String> selectorQueues = this.getMatchingQueues(null);
        this.allQueues.addAll(this.mainQueues);
        this.allQueues.addAll(selectorQueues.keySet());
    }

    @Override
    public Iterable<DistributionQueueItemStatus> add(@Nonnull DistributionPackage distributionPackage, @Nonnull DistributionQueueProvider queueProvider) throws DistributionException {
        String[] paths = distributionPackage.getInfo().getPaths();
        Map<Object, Object> matchingQueues = paths != null ? this.getMatchingQueues(paths) : new HashMap();
        MultipleQueueDispatchingStrategy dispatchingStrategy = null;
        if (matchingQueues.size() > 0) {
            Set<Object> var = matchingQueues.keySet();
            dispatchingStrategy = new MultipleQueueDispatchingStrategy(var.toArray(new String[var.size()]));
        } else {
            dispatchingStrategy = new MultipleQueueDispatchingStrategy(this.mainQueues.toArray(new String[this.mainQueues.size()]));
        }
        return dispatchingStrategy.add(distributionPackage, queueProvider);
    }

    @Override
    @Nonnull
    public List<String> getQueueNames() {
        return this.allQueues;
    }

    public Map<String, String> getMatchingQueues(String[] paths) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (paths == null) {
            paths = new String[]{null};
        }
        for (String queueSelector : this.selectors.keySet()) {
            String pathMatcher = this.selectors.get(queueSelector);
            int idx = queueSelector.indexOf(124);
            String queuePrefix = queueSelector;
            String queueMatcher = null;
            if (idx >= 0) {
                queuePrefix = queueSelector.substring(0, idx);
                queueMatcher = queueSelector.substring(idx + 1);
            }
            for (String path : paths) {
                if (path != null && !path.matches(pathMatcher)) continue;
                for (String mainQueue : this.mainQueues) {
                    if (queueMatcher != null && !mainQueue.matches(queueMatcher)) continue;
                    result.put(queuePrefix + "-" + mainQueue, mainQueue);
                }
            }
        }
        return result;
    }
}

