/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorQueueDispatchingStrategy
implements DistributionQueueDispatchingStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ERROR_PREFIX = "error-";
    private final Set<String> queueNames = new TreeSet<String>();

    public ErrorQueueDispatchingStrategy(String[] queueNames) {
        this.queueNames.addAll(Arrays.asList(queueNames));
    }

    @Override
    public Iterable<DistributionQueueItemStatus> add(@Nonnull DistributionPackage distributionPackage, @Nonnull DistributionQueueProvider queueProvider) throws DistributionException {
        ArrayList<DistributionQueueItemStatus> result = new ArrayList<DistributionQueueItemStatus>();
        String originQueue = DistributionPackageUtils.getQueueName(distributionPackage.getInfo());
        if (!this.queueNames.contains(originQueue)) {
            return result;
        }
        String errorQueueName = ERROR_PREFIX + originQueue;
        DistributionQueue errorQueue = queueProvider.getQueue(errorQueueName);
        DistributionQueueItemStatus status = new DistributionQueueItemStatus(DistributionQueueItemState.ERROR, errorQueueName);
        DistributionQueueItem queueItem = DistributionPackageUtils.toQueueItem(distributionPackage);
        DistributionPackageUtils.acquire(distributionPackage, errorQueueName);
        DistributionQueueEntry queueEntry = errorQueue.add(queueItem);
        if (queueEntry != null) {
            status = queueEntry.getStatus();
        } else {
            DistributionPackageUtils.releaseOrDelete(distributionPackage, errorQueueName);
            this.log.error("cannot add package {} to queue {}", (Object)distributionPackage.getId(), (Object)errorQueueName);
        }
        result.add(status);
        return result;
    }

    @Override
    @Nonnull
    public List<String> getQueueNames() {
        ArrayList<String> errorQueueNames = new ArrayList<String>();
        for (String queueName : this.queueNames) {
            errorQueueNames.add(ERROR_PREFIX + queueName);
        }
        return errorQueueNames;
    }
}

