/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.ReferencePackage;
import org.apache.sling.distribution.packaging.impl.SharedDistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDeliveryDispatchingStrategy
implements DistributionQueueDispatchingStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<String> queues;
    private final Map<String, String> deliveryMappings;

    public AsyncDeliveryDispatchingStrategy(Map<String, String> deliveryMappings) {
        this.deliveryMappings = deliveryMappings;
        this.queues = new LinkedList<String>();
        this.queues.addAll(deliveryMappings.keySet());
        this.queues.addAll(deliveryMappings.values());
    }

    @Override
    public Iterable<DistributionQueueItemStatus> add(@Nonnull DistributionPackage distributionPackage, @Nonnull DistributionQueueProvider queueProvider) throws DistributionException {
        if (!(distributionPackage instanceof SharedDistributionPackage) && this.deliveryMappings.size() > 1) {
            throw new DistributionException("distribution package must be a shared package to be added in multiple queues");
        }
        String distributionPackageId = distributionPackage.getId();
        LinkedList<DistributionQueueItemStatus> result = new LinkedList<DistributionQueueItemStatus>();
        for (String referenceQueueName : this.deliveryMappings.keySet()) {
            DistributionQueueItem item;
            DistributionQueue queue = queueProvider.getQueue(referenceQueueName);
            int MAX_QUEUE_ITEMS_THRESHOLD = 100;
            if (queue.getStatus().getItemsCount() > MAX_QUEUE_ITEMS_THRESHOLD) {
                distributionPackage.getInfo().put("reference-required", true);
                item = this.getItem(distributionPackage);
                ReferencePackage referencePackage = new ReferencePackage(distributionPackage);
                DistributionPackageUtils.acquire(referencePackage, referenceQueueName);
                String deliveryQueueName = this.deliveryMappings.get(referenceQueueName);
                DistributionPackageUtils.acquire(distributionPackage, deliveryQueueName);
                DistributionQueue deliveryQueue = queueProvider.getQueue(deliveryQueueName);
                DistributionQueueEntry deliveryQueueEntry = deliveryQueue.add(item);
                if (deliveryQueueEntry != null) {
                    DistributionQueueItemStatus status = deliveryQueueEntry.getStatus();
                    this.log.debug("item {}\u00a0added to delivery queue: {}", (Object)item, (Object)status);
                    result.add(status);
                } else {
                    DistributionPackageUtils.release(distributionPackage, deliveryQueueName);
                    this.log.error("cannot add package {} to delivery queue {}", (Object)distributionPackageId, (Object)deliveryQueueName);
                    result.add(new DistributionQueueItemStatus(DistributionQueueItemState.ERROR, deliveryQueue.getName()));
                }
                DistributionQueue referenceQueue = queueProvider.getQueue(referenceQueueName);
                DistributionQueueItem referenceQueueItem = this.getItem(referencePackage);
                DistributionQueueEntry referenceQueueEntry = referenceQueue.add(referenceQueueItem);
                if (referenceQueueEntry != null) {
                    DistributionQueueItemStatus status = referenceQueueEntry.getStatus();
                    this.log.debug("item {}\u00a0added to reference queue: {}", (Object)referenceQueueItem, (Object)status);
                    continue;
                }
                DistributionPackageUtils.release(referencePackage, referenceQueueName);
                this.log.error("cannot add package {} to reference queue {}", (Object)distributionPackageId, (Object)referenceQueueName);
                result.add(new DistributionQueueItemStatus(DistributionQueueItemState.ERROR, referenceQueue.getName()));
                continue;
            }
            item = this.getItem(distributionPackage);
            DistributionQueueItemStatus status = new DistributionQueueItemStatus(DistributionQueueItemState.ERROR, queue.getName());
            DistributionPackageUtils.acquire(distributionPackage, referenceQueueName);
            DistributionQueueEntry queueEntry = queue.add(item);
            if (queueEntry != null) {
                status = queueEntry.getStatus();
                this.log.debug("item {}\u00a0added to queue: {}", (Object)item, (Object)status);
            } else {
                DistributionPackageUtils.release(distributionPackage, referenceQueueName);
                this.log.error("cannot add package {} to queue {}", (Object)distributionPackageId, (Object)referenceQueueName);
            }
            result.add(status);
        }
        return result;
    }

    @Override
    @Nonnull
    public List<String> getQueueNames() {
        return this.queues;
    }

    private DistributionQueueItem getItem(DistributionPackage distributionPackage) {
        return DistributionPackageUtils.toQueueItem(distributionPackage);
    }
}

