/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporter;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;

@Component(label="Apache Sling Distribution Importer - Remote Package Importer Factory", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageImporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Importer name: {name}"})
public class RemoteDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Property(label="Name", description="The name of the importer.")
    private static final String NAME = "name";
    @Property(cardinality=100, label="Endpoints", description="The list of endpoints to which the packages will be imported.")
    private static final String ENDPOINTS = "endpoints";
    @Property(name="transportSecretProvider.target", label="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.")
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    private DistributionPackageImporter importer;

    @Activate
    protected void activate(Map<String, Object> config) {
        Map<String, String> endpoints = SettingsUtils.toUriMap(config.get(ENDPOINTS));
        String importerName = PropertiesUtil.toString((Object)config.get(NAME), null);
        DefaultDistributionLog distributionLog = new DefaultDistributionLog(DistributionComponentKind.IMPORTER, importerName, RemoteDistributionPackageImporter.class, DefaultDistributionLog.LogLevel.ERROR);
        HttpConfiguration httpConfiguration = new HttpConfiguration(10000);
        this.importer = new RemoteDistributionPackageImporter(distributionLog, this.transportSecretProvider, endpoints, httpConfiguration);
    }

    @Override
    public void importPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @Nonnull
    public DistributionPackageInfo importStream(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    protected void bindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        this.transportSecretProvider = distributionTransportSecretProvider;
    }

    protected void unbindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        if (this.transportSecretProvider == distributionTransportSecretProvider) {
            this.transportSecretProvider = null;
        }
    }
}

