/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.ReferencePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDistributionPackageImporter
implements DistributionPackageImporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionPackageBuilder packageBuilder;
    private final DistributionEventFactory eventFactory;
    private final String name;

    public LocalDistributionPackageImporter(String name, DistributionEventFactory eventFactory, DistributionPackageBuilder packageBuilder) {
        if (packageBuilder == null) {
            throw new IllegalArgumentException("A package builder is required");
        }
        if (eventFactory == null) {
            throw new IllegalArgumentException("EventFactory is required");
        }
        if (name == null) {
            throw new IllegalArgumentException("An importer name is required");
        }
        this.packageBuilder = packageBuilder;
        this.eventFactory = eventFactory;
        this.name = name;
    }

    @Override
    public void importPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionPackage distributionPackage) throws DistributionException {
        boolean success = this.packageBuilder.installPackage(resourceResolver, distributionPackage);
        if (!success) {
            this.log.warn("could not install distribution package {}", (Object)distributionPackage.getId());
        }
        this.eventFactory.generatePackageEvent("org/apache/sling/distribution/importer/package/imported", DistributionComponentKind.IMPORTER, this.name, distributionPackage.getInfo());
    }

    @Override
    @Nonnull
    public DistributionPackageInfo importStream(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        String reference;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        HashMap<String, Object> headerInfo = new HashMap<String, Object>();
        DistributionPackageUtils.readInfo(stream, headerInfo);
        this.log.debug("header info: {}", headerInfo);
        Object o = headerInfo.get("remote.package.id");
        String string = reference = o != null ? String.valueOf(o) : null;
        if (reference != null) {
            DistributionPackageInfo packageInfo;
            boolean store;
            if (ReferencePackage.isReference(reference)) {
                String actualPackageId = ReferencePackage.idFromReference(reference);
                if (actualPackageId != null) {
                    this.log.info("installing from reference {}", (Object)actualPackageId);
                    DistributionPackage distributionPackage = this.packageBuilder.getPackage(resourceResolver, actualPackageId);
                    if (distributionPackage != null) {
                        if (this.packageBuilder.installPackage(resourceResolver, distributionPackage)) {
                            DistributionPackageInfo info = distributionPackage.getInfo();
                            this.log.info("package installed {}", (Object)info);
                            this.eventFactory.generatePackageEvent("org/apache/sling/distribution/importer/package/imported", DistributionComponentKind.IMPORTER, this.name, info);
                            return info;
                        }
                        throw new DistributionException("could not install package {}" + distributionPackage);
                    }
                    throw new DistributionException("could not install package from reference " + actualPackageId);
                }
                throw new DistributionException("could not install package from invalid reference " + reference);
            }
            try {
                stream.reset();
            }
            catch (IOException actualPackageId) {
                // empty catch block
            }
            Object rr = headerInfo.get("reference-required");
            boolean bl = store = rr != null && Boolean.valueOf(rr.toString()) != false;
            if (store) {
                this.log.debug("storing actual package");
                DistributionPackage distributionPackage = this.packageBuilder.readPackage(resourceResolver, stream);
                packageInfo = distributionPackage.getInfo();
                this.log.info("package stored {}", (Object)packageInfo);
            } else {
                packageInfo = this.packageBuilder.installPackage(resourceResolver, stream);
                this.log.info("package installed {}", (Object)packageInfo);
            }
            this.eventFactory.generatePackageEvent("org/apache/sling/distribution/importer/package/imported", DistributionComponentKind.IMPORTER, this.name, packageInfo);
            return packageInfo;
        }
        DistributionPackageInfo packageInfo = this.packageBuilder.installPackage(resourceResolver, stream);
        this.log.info("package installed");
        this.eventFactory.generatePackageEvent("org/apache/sling/distribution/importer/package/imported", DistributionComponentKind.IMPORTER, this.name, packageInfo);
        return packageInfo;
    }
}

