/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporter;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Distribution Exporter - Remote Package Exporter Factory", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageExporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Exporter name: {name}"})
public class RemoteDistributionPackageExporterFactory
implements DistributionPackageExporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(label="Name", description="The name of the exporter.")
    private static final String NAME = "name";
    @Property(cardinality=100, label="Endpoints", description="The list of endpoints from which the packages will be exported.")
    private static final String ENDPOINTS = "endpoints";
    @Property(label="Pull Items", description="number of subsequent pull requests to make", intValue={1})
    private static final String PULL_ITEMS = "pull.items";
    @Property(name="packageBuilder.target", label="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Property(name="transportSecretProvider.target", label="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    private DistributionPackageExporter exporter;

    @Activate
    protected void activate(Map<String, Object> config) throws Exception {
        this.log.info("activating remote exporter with pb {} and dtsp {}", (Object)this.packageBuilder, (Object)this.transportSecretProvider);
        String[] endpoints = PropertiesUtil.toStringArray((Object)config.get(ENDPOINTS), (String[])new String[0]);
        endpoints = SettingsUtils.removeEmptyEntries(endpoints);
        int pollItems = PropertiesUtil.toInteger((Object)config.get(PULL_ITEMS), (int)Integer.MAX_VALUE);
        String exporterName = PropertiesUtil.toString((Object)config.get(NAME), null);
        DefaultDistributionLog distributionLog = new DefaultDistributionLog(DistributionComponentKind.EXPORTER, exporterName, RemoteDistributionPackageExporter.class, DefaultDistributionLog.LogLevel.ERROR);
        HttpConfiguration httpConfiguration = new HttpConfiguration(10000);
        this.exporter = new RemoteDistributionPackageExporter(distributionLog, this.packageBuilder, this.transportSecretProvider, endpoints, pollItems, httpConfiguration);
    }

    @Deactivate
    protected void deactivate() {
        this.exporter = null;
    }

    @Override
    public void exportPackages(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest, @Nonnull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.exporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String distributionPackageId) throws DistributionException {
        return this.exporter.getPackage(resourceResolver, distributionPackageId);
    }

    protected void bindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        this.packageBuilder = distributionPackageBuilder;
    }

    protected void unbindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        if (this.packageBuilder == distributionPackageBuilder) {
            this.packageBuilder = null;
        }
    }

    protected void bindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        this.transportSecretProvider = distributionTransportSecretProvider;
    }

    protected void unbindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        if (this.transportSecretProvider == distributionTransportSecretProvider) {
            this.transportSecretProvider = null;
        }
    }
}

