/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.DistributionEndpoint;
import org.apache.sling.distribution.transport.impl.DistributionTransport;
import org.apache.sling.distribution.transport.impl.DistributionTransportContext;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.transport.impl.RemoteDistributionPackage;
import org.apache.sling.distribution.transport.impl.SimpleHttpDistributionTransport;

public class RemoteDistributionPackageExporter
implements DistributionPackageExporter {
    private final DistributionPackageBuilder packageBuilder;
    private final int maxPullItems;
    private final DistributionTransportContext distributionContext = new DistributionTransportContext();
    private final List<DistributionTransport> transportHandlers = new ArrayList<DistributionTransport>();

    public RemoteDistributionPackageExporter(DefaultDistributionLog log, DistributionPackageBuilder packageBuilder, DistributionTransportSecretProvider secretProvider, String[] endpoints, int maxPullItems, HttpConfiguration httpConfiguration) {
        this.maxPullItems = maxPullItems;
        if (packageBuilder == null) {
            throw new IllegalArgumentException("packageBuilder is required");
        }
        if (secretProvider == null) {
            throw new IllegalArgumentException("distributionTransportSecretProvider is required");
        }
        this.packageBuilder = packageBuilder;
        for (String endpoint : endpoints) {
            if (endpoint == null || endpoint.length() <= 0) continue;
            this.transportHandlers.add(new SimpleHttpDistributionTransport(log, new DistributionEndpoint(endpoint), packageBuilder, secretProvider, httpConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportPackages(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest, @Nonnull DistributionPackageProcessor packageProcessor) throws DistributionException {
        int maxNumberOfPackages = DistributionRequestType.PULL.equals((Object)distributionRequest.getRequestType()) ? this.maxPullItems : 1;
        for (DistributionTransport distributionTransport : this.transportHandlers) {
            RemoteDistributionPackage retrievedPackage;
            for (int noPackages = 0; noPackages < maxNumberOfPackages && (retrievedPackage = distributionTransport.retrievePackage(resourceResolver, distributionRequest, this.distributionContext)) != null; ++noPackages) {
                DistributionPackage distributionPackage = retrievedPackage.getPackage();
                try {
                    packageProcessor.process(distributionPackage);
                    retrievedPackage.deleteRemotePackage();
                    continue;
                }
                finally {
                    DistributionPackageUtils.closeSafely(distributionPackage);
                }
            }
        }
    }

    @Override
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String distributionPackageId) throws DistributionException {
        return this.packageBuilder.getPackage(resourceResolver, distributionPackageId);
    }
}

