/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporter;

@Component(label="Apache Sling Distribution Exporter - Local Package Exporter Factory", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageExporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Exporter name: {name}"})
public class LocalDistributionPackageExporterFactory
implements DistributionPackageExporter {
    @Property(label="Name", description="The name of the exporter.")
    public static final String NAME = "name";
    @Property(name="packageBuilder.target", label="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    private DistributionPackageExporter exporter;

    @Activate
    public void activate(Map<String, Object> config) {
        this.exporter = new LocalDistributionPackageExporter(this.packageBuilder);
    }

    @Override
    public void exportPackages(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest, @Nonnull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.exporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String distributionPackageId) throws DistributionException {
        return this.exporter.getPackage(resourceResolver, distributionPackageId);
    }

    protected void bindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        this.packageBuilder = distributionPackageBuilder;
    }

    protected void unbindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        if (this.packageBuilder == distributionPackageBuilder) {
            this.packageBuilder = null;
        }
    }
}

