/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.log.DistributionLog;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.DistributionPackageWrapper;
import org.apache.sling.distribution.packaging.impl.SimpleDistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentDistributionPackageExporter
implements DistributionPackageExporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionPackageBuilderProvider packageBuilderProvider;
    private final String name;
    private static final String PACKAGE_TYPE = "agentexporter";
    private DistributionAgent agent;
    private String queueName;

    public AgentDistributionPackageExporter(String queueName, DistributionAgent agent, DistributionPackageBuilderProvider packageBuilderProvider, String name) {
        this.packageBuilderProvider = packageBuilderProvider;
        this.name = name;
        if (agent == null || packageBuilderProvider == null) {
            throw new IllegalArgumentException("Agent and package builder are required");
        }
        this.queueName = queueName;
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportPackages(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest, @Nonnull DistributionPackageProcessor packageProcessor) throws DistributionException {
        if (DistributionRequestType.TEST.equals((Object)distributionRequest.getRequestType())) {
            packageProcessor.process(new SimpleDistributionPackage(distributionRequest, PACKAGE_TYPE));
            return;
        }
        if (!DistributionRequestType.PULL.equals((Object)distributionRequest.getRequestType())) {
            throw new DistributionException("request type not supported " + distributionRequest.getRequestType());
        }
        DistributionPackage distributionPackage = null;
        try {
            this.log.debug("getting packages from queue {}", (Object)this.queueName);
            DistributionQueue queue = this.getQueueOrThrow(this.queueName);
            DistributionQueueEntry entry = queue.getHead();
            if (entry != null) {
                DistributionQueueItem queueItem = entry.getItem();
                DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(queueItem);
                DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(info.getType());
                if (packageBuilder != null) {
                    distributionPackage = packageBuilder.getPackage(resourceResolver, queueItem.getPackageId());
                    if (distributionPackage != null) {
                        distributionPackage.getInfo().putAll((Map)((Object)info));
                        this.log.debug("item {} fetched from the queue", (Object)info);
                        packageProcessor.process(new AgentDistributionPackage(distributionPackage, queue, entry.getId()));
                    } else {
                        this.log.warn("cannot get package {}", (Object)info);
                    }
                } else {
                    this.log.warn("cannot find package builder with type {}", (Object)info.getType());
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error exporting package", (Throwable)ex);
        }
        finally {
            DistributionPackageUtils.closeSafely(distributionPackage);
        }
    }

    @Override
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String distributionPackageId) {
        try {
            this.log.debug("getting package from queue {}", (Object)this.queueName);
            DistributionQueue queue = this.getQueueOrThrow(this.queueName);
            DistributionQueueEntry entry = queue.getItem(distributionPackageId);
            if (entry != null) {
                DistributionQueueItem queueItem = entry.getItem();
                DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(queueItem);
                DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(info.getType());
                if (packageBuilder != null) {
                    DistributionPackage distributionPackage = packageBuilder.getPackage(resourceResolver, queueItem.getPackageId());
                    distributionPackage.getInfo().putAll((Map)((Object)info));
                    this.log.debug("item {} fetched from the queue", (Object)info);
                    if (distributionPackage != null) {
                        return new AgentDistributionPackage(distributionPackage, queue, entry.getId());
                    }
                } else {
                    this.log.warn("cannot find package builder with type {}", (Object)info.getType());
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error exporting package", (Throwable)ex);
        }
        return null;
    }

    private void agentLog(String message, Object[] values) {
        DistributionLog agentLog = this.agent.getLog();
        if (agentLog instanceof DefaultDistributionLog) {
            ((DefaultDistributionLog)agentLog).info(message, values);
        }
    }

    @Nonnull
    private DistributionQueue getQueueOrThrow(@Nonnull String queueName) throws DistributionException {
        DistributionQueue queue = this.agent.getQueue(queueName);
        if (queue == null) {
            throw new DistributionException(String.format("Could not find queue %s", queueName));
        }
        return queue;
    }

    private class AgentDistributionPackage
    extends DistributionPackageWrapper {
        private final DistributionPackage distributionPackage;
        private final DistributionQueue queue;
        private final String itemId;

        AgentDistributionPackage(DistributionPackage distributionPackage, DistributionQueue queue, String itemId) {
            super(distributionPackage);
            this.distributionPackage = distributionPackage;
            this.queue = queue;
            this.itemId = itemId;
        }

        @Override
        public void delete() {
            this.queue.remove(this.itemId);
            DistributionPackageUtils.releaseOrDelete(this.distributionPackage, this.queue.getName());
            AgentDistributionPackageExporter.this.agentLog("exported package {} with info {} from queue {} by exporter {}", new Object[]{this.itemId, this.distributionPackage.getInfo(), this.queue.getName(), AgentDistributionPackageExporter.this.name});
        }

        @Override
        @Nonnull
        public String getId() {
            return this.itemId;
        }
    }
}

