/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.apache.sling.distribution.packaging.impl.SharedDistributionPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDistributionPackage
extends AbstractDistributionPackage
implements SharedDistributionPackage {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributionPackage.class);
    private static final String PACKAGE_START = "DSTRPCK:";
    private static final String DELIM = "|";
    private static final String PATH_DELIM = ",";
    private final long size;

    public SimpleDistributionPackage(DistributionRequest request, String type) {
        super(SimpleDistributionPackage.toIdString(request), type, null, null);
        String[] paths = request.getPaths();
        DistributionRequestType requestType = request.getRequestType();
        this.getInfo().put("request.paths", paths);
        this.getInfo().put("request.type", requestType);
        this.size = this.getId().toCharArray().length;
    }

    private static String toIdString(DistributionRequest request) {
        StringBuilder b = new StringBuilder();
        b.append(PACKAGE_START);
        b.append(request.getRequestType().toString());
        b.append(DELIM);
        String[] paths = request.getPaths();
        if (paths == null || paths.length == 0) {
            b.append(PATH_DELIM);
        } else {
            for (int i = 0; i < paths.length; ++i) {
                b.append(paths[i]);
                if (i >= paths.length - 1) continue;
                b.append(PATH_DELIM);
            }
        }
        return b.toString();
    }

    public static SimpleDistributionPackage fromIdString(String id, String type) {
        if (!id.startsWith(PACKAGE_START)) {
            return null;
        }
        String[] parts = (id = id.substring(PACKAGE_START.length())).split(Pattern.quote(DELIM));
        if (parts.length < 1 || parts.length > 2) {
            return null;
        }
        String actionString = parts[0];
        String pathsString = parts.length < 2 ? null : parts[1];
        DistributionRequestType distributionRequestType = DistributionRequestType.fromName((String)actionString);
        SimpleDistributionPackage distributionPackage = null;
        if (distributionRequestType != null) {
            String[] paths = pathsString == null ? new String[]{} : pathsString.split(PATH_DELIM);
            SimpleDistributionRequest request = new SimpleDistributionRequest(distributionRequestType, paths);
            distributionPackage = new SimpleDistributionPackage((DistributionRequest)request, type);
        }
        return distributionPackage;
    }

    @Override
    @Nonnull
    public InputStream createInputStream() throws IOException {
        return IOUtils.toInputStream((String)this.getId(), (String)"UTF-8");
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
    }

    public String toString() {
        return this.getId();
    }

    public static SimpleDistributionPackage fromStream(InputStream stream, String type) {
        try {
            int size = PACKAGE_START.getBytes("UTF-8").length;
            stream.mark(size);
            byte[] buffer = new byte[size];
            int bytesRead = stream.read(buffer, 0, size);
            stream.reset();
            String s = new String(buffer, "UTF-8");
            if (bytesRead > 0 && buffer[0] > 0 && s.startsWith(PACKAGE_START)) {
                String streamString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                return SimpleDistributionPackage.fromIdString(streamString, type);
            }
        }
        catch (IOException e) {
            log.error("cannot read stream", (Throwable)e);
        }
        return null;
    }

    @Override
    public void acquire(String ... holderNames) {
    }

    @Override
    public void release(String ... holderNames) {
    }
}

