/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackage;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDistributionPackageCleanup
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResourceDistributionPackageBuilder packageBuilder;
    private final ResourceResolverFactory resolverFactory;

    public ResourceDistributionPackageCleanup(@Nonnull ResourceResolverFactory resolverFactory, @Nonnull ResourceDistributionPackageBuilder packageBuilder) {
        this.resolverFactory = resolverFactory;
        this.packageBuilder = packageBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.debug("Cleaning up {} packages", (Object)this.packageBuilder.getType());
        ResourceResolver serviceResolver = null;
        try {
            int deleted = 0;
            int total = 0;
            serviceResolver = this.resolverFactory.getServiceResourceResolver(null);
            Iterator<ResourceDistributionPackage> pkgs = this.packageBuilder.getPackages(serviceResolver);
            while (pkgs.hasNext()) {
                ResourceDistributionPackage pkg = pkgs.next();
                if (pkg.disposable()) {
                    this.log.debug("Delete package {}", (Object)pkg.getId());
                    ++deleted;
                    pkg.delete(false);
                } else {
                    this.log.debug("package {} is not disposable", (Object)pkg.getId());
                }
                ++total;
            }
            if (serviceResolver.hasChanges()) {
                serviceResolver.commit();
            }
            this.log.debug("Cleaned up {}/{} {} packages", new Object[]{deleted, total, this.packageBuilder.getType()});
        }
        catch (LoginException e) {
            this.log.error("Failed to get distribution service resolver: {}", (Object)e.getMessage());
        }
        catch (DistributionException e) {
            this.log.error("Failed to get the list of packages", (Throwable)e);
        }
        catch (PersistenceException e) {
            this.log.error("Failed to delete disposable packages", (Throwable)e);
        }
        finally {
            if (serviceResolver != null && serviceResolver.isLive()) {
                serviceResolver.close();
            }
        }
    }
}

