/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDistributionPackage
extends AbstractDistributionPackage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public FileDistributionPackage(@Nonnull File file, @Nonnull String type, @Nullable String digestAlgorithm, @Nullable String digestMessage) {
        super(file.getName(), type, digestAlgorithm, digestMessage);
        this.file = file;
        this.getInfo().put("request.type", DistributionRequestType.ADD);
    }

    @Override
    @Nonnull
    public InputStream createInputStream() throws IOException {
        return new PackageInputStream(this.file);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        FileUtils.deleteQuietly((File)this.file);
        FileUtils.deleteQuietly((File)this.getStatusFile());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void acquire(String ... holderNames) {
        try {
            DistributionPackageUtils.acquire(this.getStatusFile(), holderNames);
        }
        catch (IOException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    @Override
    public void release(String ... holderNames) {
        try {
            boolean doDelete = DistributionPackageUtils.release(this.getStatusFile(), holderNames);
            if (doDelete) {
                this.delete();
            }
        }
        catch (IOException e) {
            this.log.error("cannot release package", (Throwable)e);
        }
    }

    private File getStatusFile() {
        String statusFilePath = this.file.getAbsolutePath() + ".status";
        return new File(statusFilePath);
    }

    public class PackageInputStream
    extends BufferedInputStream {
        private final File file;

        public PackageInputStream(File file) throws IOException {
            super(FileUtils.openInputStream((File)file));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

