/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.SharedDistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionPackageUtils {
    private static final Logger log = LoggerFactory.getLogger(DistributionPackageUtils.class);
    private static final String META_START = "DSTRPACKMETA";
    private static final Object repolock = new Object();
    private static final Object filelock = new Object();
    public static final String PROPERTY_REMOTE_PACKAGE_ID = "remote.package.id";
    private static final String PACKAGE_INFO_PROPERTY_ORIGIN_QUEUE = "internal.origin.queue";
    public static final String PACKAGE_INFO_PROPERTY_REQUEST_USER = "internal.request.user";
    public static final String PACKAGE_INFO_PROPERTY_REQUEST_ID = "internal.request.id";
    public static final String PACKAGE_INFO_PROPERTY_REQUEST_START_TIME = "internal.request.startTime";

    public static void acquire(DistributionPackage distributionPackage, String ... queueNames) {
        if (distributionPackage instanceof SharedDistributionPackage) {
            ((SharedDistributionPackage)distributionPackage).acquire(queueNames);
        }
    }

    public static void release(DistributionPackage distributionPackage, String ... queueNames) {
        if (distributionPackage instanceof SharedDistributionPackage) {
            ((SharedDistributionPackage)distributionPackage).release(queueNames);
        }
    }

    public static void releaseOrDelete(DistributionPackage distributionPackage, String ... queueNames) {
        if (distributionPackage == null) {
            return;
        }
        try {
            if (distributionPackage instanceof SharedDistributionPackage) {
                if (queueNames != null) {
                    ((SharedDistributionPackage)distributionPackage).release(queueNames);
                    log.debug("package {} released from queue {}", (Object)distributionPackage.getId(), (Object)queueNames);
                } else {
                    log.error("package {} cannot be released from null queue", (Object)distributionPackage.getId());
                }
            } else {
                DistributionPackageUtils.deleteSafely(distributionPackage);
                log.debug("package {} deleted", (Object)distributionPackage.getId());
            }
        }
        catch (Throwable t) {
            log.error("cannot release package {}", t);
        }
    }

    private static void deleteSafely(DistributionPackage distributionPackage) {
        if (distributionPackage != null) {
            try {
                distributionPackage.delete();
            }
            catch (Throwable t) {
                log.error("error deleting package", t);
            }
        }
    }

    public static void closeSafely(DistributionPackage distributionPackage) {
        if (distributionPackage != null) {
            try {
                distributionPackage.close();
            }
            catch (Throwable t) {
                log.error("error closing package", t);
            }
        }
    }

    public static DistributionQueueItem toQueueItem(DistributionPackage distributionPackage) {
        return new DistributionQueueItem(distributionPackage.getId(), distributionPackage.getSize(), (Map<String, Object>)((Object)distributionPackage.getInfo()));
    }

    public static DistributionPackageInfo fromQueueItem(DistributionQueueItem queueItem) {
        String type = (String)queueItem.get("package.type", String.class);
        return new DistributionPackageInfo(type, (Map<String, Object>)((Object)queueItem));
    }

    public static String getQueueName(DistributionPackageInfo packageInfo) {
        return (String)packageInfo.get(PACKAGE_INFO_PROPERTY_ORIGIN_QUEUE, String.class);
    }

    public static void mergeQueueEntry(DistributionPackageInfo packageInfo, DistributionQueueEntry entry) {
        packageInfo.putAll((Map)((Object)entry.getItem()));
        packageInfo.put(PACKAGE_INFO_PROPERTY_ORIGIN_QUEUE, entry.getStatus().getQueueName());
    }

    public static void fillInfo(DistributionPackageInfo info, DistributionRequest request) {
        info.put("request.type", request.getRequestType());
        info.put("request.paths", request.getPaths());
        info.put("request.deepPaths", DistributionPackageUtils.getDeepPaths(request));
    }

    private static String[] getDeepPaths(DistributionRequest request) {
        ArrayList<String> deepPaths = new ArrayList<String>();
        for (String path : request.getPaths()) {
            if (!request.isDeep(path)) continue;
            deepPaths.add(path);
        }
        return deepPaths.toArray(new String[deepPaths.size()]);
    }

    public static InputStream createStreamWithHeader(DistributionPackage distributionPackage) throws IOException {
        DistributionPackageInfo packageInfo = distributionPackage.getInfo();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashMap<String, Object> headerInfo = new HashMap<String, Object>();
        headerInfo.put("request.type", packageInfo.getRequestType());
        headerInfo.put("request.paths", packageInfo.getPaths());
        headerInfo.put(PROPERTY_REMOTE_PACKAGE_ID, distributionPackage.getId());
        if (packageInfo.containsKey("reference-required")) {
            headerInfo.put("reference-required", packageInfo.get("reference-required"));
            log.info("setting reference-required to {}", packageInfo.get("reference-required"));
        }
        DistributionPackageUtils.writeInfo(outputStream, headerInfo);
        ByteArrayInputStream headerStream = new ByteArrayInputStream(outputStream.toByteArray());
        InputStream bodyStream = distributionPackage.createInputStream();
        return new SequenceInputStream(headerStream, bodyStream);
    }

    public static void readInfo(InputStream inputStream, Map<String, Object> info) {
        try {
            int size = META_START.getBytes("UTF-8").length;
            inputStream.mark(size);
            byte[] buffer = new byte[size];
            int bytesRead = inputStream.read(buffer, 0, size);
            String s = new String(buffer, "UTF-8");
            if (bytesRead > 0 && buffer[0] > 0 && META_START.equals(s)) {
                ObjectInputStream stream = DistributionPackageUtils.getSafeObjectInputStream(inputStream);
                HashMap map = (HashMap)stream.readObject();
                info.putAll(map);
            } else {
                inputStream.reset();
            }
        }
        catch (IOException e) {
            log.error("Cannot read stream info", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Cannot read stream info", (Throwable)e);
        }
    }

    public static void writeInfo(OutputStream outputStream, Map<String, Object> info) {
        HashMap<String, Object> map = new HashMap<String, Object>(info);
        try {
            outputStream.write(META_START.getBytes("UTF-8"));
            ObjectOutputStream stream = new ObjectOutputStream(outputStream);
            stream.writeObject(map);
        }
        catch (IOException e) {
            log.error("Cannot read stream info", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getPackagesRoot(ResourceResolver resourceResolver, String packagesRootPath) throws PersistenceException {
        Resource packagesRoot = resourceResolver.getResource(packagesRootPath);
        if (packagesRoot != null) {
            return packagesRoot;
        }
        Object object = repolock;
        synchronized (object) {
            if (resourceResolver.hasChanges()) {
                resourceResolver.refresh();
            }
            packagesRoot = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)packagesRootPath, (String)"sling:Folder", (String)"sling:Folder", (boolean)true);
        }
        return packagesRoot;
    }

    public static InputStream getStream(Resource resource) throws RepositoryException {
        Node parent = (Node)resource.adaptTo(Node.class);
        return parent.getProperty("bin/jcr:content/jcr:data").getBinary().getStream();
    }

    public static void uploadStream(Resource resource, InputStream stream) throws RepositoryException {
        Node parent = (Node)resource.adaptTo(Node.class);
        Node file = JcrUtils.getOrAddNode((Node)parent, (String)"bin", (String)"{http://www.jcp.org/jcr/nt/1.0}file");
        Node content = JcrUtils.getOrAddNode((Node)file, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
        Binary binary = parent.getSession().getValueFactory().createBinary(stream);
        content.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
        JcrUtils.getOrAddNode((Node)parent, (String)"refs", (String)"{http://www.jcp.org/jcr/nt/1.0}unstructured");
    }

    public static void acquire(Resource resource, @Nonnull String[] holderNames) throws RepositoryException {
        if (holderNames.length == 0) {
            throw new IllegalArgumentException("holder name cannot be null or empty");
        }
        Node parent = (Node)resource.adaptTo(Node.class);
        Node refs = parent.getNode("refs");
        for (String holderName : holderNames) {
            if (refs.hasNode(holderName)) continue;
            refs.addNode(holderName, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        }
    }

    public static boolean disposable(@Nonnull Resource resource) throws RepositoryException {
        Node parent = (Node)resource.adaptTo(Node.class);
        if (parent.hasNode("refs")) {
            Node refs = parent.getNode("refs");
            return !refs.hasNodes() && refs.hasProperty("released");
        }
        log.warn("Package {} has no refs resource. Consider removing it explicitly.", (Object)resource.getPath());
        return false;
    }

    public static void release(Resource resource, @Nonnull String[] holderNames) throws RepositoryException {
        if (holderNames.length == 0) {
            throw new IllegalArgumentException("holder name cannot be null or empty");
        }
        Node parent = (Node)resource.adaptTo(Node.class);
        Node refs = parent.getNode("refs");
        for (String holderName : holderNames) {
            Node refNode = refs.getNode(holderName);
            if (refNode == null) continue;
            refNode.remove();
        }
        if (!refs.hasProperty("released")) {
            refs.setProperty("released", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquire(File file, @Nonnull String[] holderNames) throws IOException {
        if (holderNames.length == 0) {
            throw new IllegalArgumentException("holder name cannot be null or empty");
        }
        Object object = filelock;
        synchronized (object) {
            ObjectInputStream inputStream = null;
            ObjectOutputStream outputStream = null;
            try {
                HashSet set;
                if (file.exists()) {
                    HashSet fromStreamSet;
                    inputStream = DistributionPackageUtils.getSafeObjectInputStream(new FileInputStream(file));
                    set = fromStreamSet = (HashSet)inputStream.readObject();
                } else {
                    set = new HashSet();
                }
                set.addAll(Arrays.asList(holderNames));
                outputStream = new ObjectOutputStream(new FileOutputStream(file));
                outputStream.writeObject(set);
            }
            catch (ClassNotFoundException e) {
                try {
                    log.error("Cannot release file", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean release(File file, @Nonnull String[] holderNames) throws IOException {
        if (holderNames.length == 0) {
            throw new IllegalArgumentException("holder name cannot be null or empty");
        }
        Object object = filelock;
        synchronized (object) {
            block14: {
                HashSet set;
                ObjectOutputStream outputStream;
                ObjectInputStream inputStream;
                block13: {
                    inputStream = null;
                    outputStream = null;
                    if (file.exists()) {
                        HashSet fromStreamSet;
                        inputStream = DistributionPackageUtils.getSafeObjectInputStream(new FileInputStream(file));
                        set = fromStreamSet = (HashSet)inputStream.readObject();
                    } else {
                        set = new HashSet();
                    }
                    set.removeAll(Arrays.asList(holderNames));
                    if (!set.isEmpty()) break block13;
                    FileUtils.deleteQuietly((File)file);
                    boolean bl = true;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    return bl;
                }
                try {
                    outputStream = new ObjectOutputStream(new FileOutputStream(file));
                    outputStream.writeObject(set);
                }
                catch (ClassNotFoundException e) {
                    try {
                        log.error("Cannot release file", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    break block14;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            return false;
        }
    }

    private static ObjectInputStream getSafeObjectInputStream(InputStream inputStream) throws IOException {
        final Class[] acceptedClasses = new Class[]{HashMap.class, HashSet.class, String.class, String[].class, Long.class, Number.class, Boolean.class, Enum.class, DistributionRequestType.class};
        return new ObjectInputStream(inputStream){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                String className = osc.getName();
                for (Class clazz : acceptedClasses) {
                    if (!clazz.getName().equals(className)) continue;
                    return super.resolveClass(osc);
                }
                throw new InvalidClassException("Class name not accepted: " + className);
            }
        };
    }
}

