/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.ReferencePackage;
import org.apache.sling.distribution.packaging.impl.SimpleDistributionPackage;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.util.DistributionJcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistributionPackageBuilder
implements DistributionPackageBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String type;

    AbstractDistributionPackageBuilder(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public DistributionPackage createPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest request) throws DistributionException {
        DistributionPackage distributionPackage;
        if (DistributionRequestType.ADD.equals((Object)(request = VltUtils.sanitizeRequest(request)).getRequestType())) {
            distributionPackage = this.createPackageForAdd(resourceResolver, request);
        } else if (DistributionRequestType.DELETE.equals((Object)request.getRequestType())) {
            distributionPackage = new SimpleDistributionPackage(request, this.type);
        } else if (DistributionRequestType.PULL.equals((Object)request.getRequestType())) {
            distributionPackage = new SimpleDistributionPackage(request, this.type);
        } else if (DistributionRequestType.TEST.equals((Object)request.getRequestType())) {
            distributionPackage = new SimpleDistributionPackage(request, this.type);
        } else {
            throw new DistributionException("unknown action type " + request.getRequestType());
        }
        DistributionPackageUtils.fillInfo(distributionPackage.getInfo(), request);
        return distributionPackage;
    }

    @Override
    @Nonnull
    public DistributionPackage readPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        HashMap<String, Object> headerInfo = new HashMap<String, Object>();
        DistributionPackageUtils.readInfo(stream, headerInfo);
        try {
            stream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DistributionPackage distributionPackage = SimpleDistributionPackage.fromStream(stream, this.type);
        try {
            stream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (distributionPackage == null) {
            distributionPackage = this.readPackageInternal(resourceResolver, stream);
        }
        distributionPackage.getInfo().putAll(headerInfo);
        return distributionPackage;
    }

    @Override
    public boolean installPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionPackage distributionPackage) throws DistributionException {
        DistributionRequestType actionType = distributionPackage.getInfo().getRequestType();
        if (!this.type.equals(distributionPackage.getType())) {
            throw new DistributionException("not supported package type" + distributionPackage.getType());
        }
        boolean installed = false;
        if (DistributionRequestType.DELETE.equals((Object)actionType)) {
            installed = this.installDeletePackage(resourceResolver, distributionPackage);
        } else if (DistributionRequestType.TEST.equals((Object)actionType)) {
            installed = true;
        } else if (DistributionRequestType.ADD.equals((Object)actionType)) {
            installed = this.installAddPackage(resourceResolver, distributionPackage);
        }
        return installed;
    }

    @Override
    @Nonnull
    public DistributionPackageInfo installPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull InputStream stream) throws DistributionException {
        boolean installed;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        DistributionPackageInfo packageInfo = new DistributionPackageInfo(this.type);
        DistributionPackageUtils.readInfo(stream, (Map<String, Object>)((Object)packageInfo));
        SimpleDistributionPackage distributionPackage = SimpleDistributionPackage.fromStream(stream, this.type);
        if (distributionPackage == null) {
            installed = this.installPackageInternal(resourceResolver, stream);
        } else {
            installed = this.installPackage(resourceResolver, distributionPackage);
            packageInfo.putAll((Map)((Object)distributionPackage.getInfo()));
        }
        if (installed) {
            return packageInfo;
        }
        throw new DistributionException("could not install package from stream");
    }

    private boolean installDeletePackage(@Nonnull ResourceResolver resourceResolver, @CheckForNull DistributionPackage distributionPackage) throws DistributionException {
        Session session = null;
        try {
            if (distributionPackage != null) {
                session = this.getSession(resourceResolver);
                for (String path : distributionPackage.getInfo().getPaths()) {
                    if (!session.itemExists(path)) continue;
                    session.removeItem(path);
                }
                boolean bl = true;
                this.ungetSession(session);
                return bl;
            }
            this.ungetSession(session);
        }
        catch (Exception e) {
            try {
                throw new DistributionException(e);
            }
            catch (Throwable throwable) {
                this.ungetSession(session);
                throw throwable;
            }
        }
        return false;
    }

    private boolean installAddPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionPackage distributionPackage) throws DistributionException {
        InputStream inputStream = null;
        try {
            inputStream = distributionPackage.createInputStream();
            boolean bl = this.installPackageInternal(resourceResolver, inputStream);
            return bl;
        }
        catch (IOException e) {
            throw new DistributionException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    @CheckForNull
    public DistributionPackage getPackage(@Nonnull ResourceResolver resourceResolver, @Nonnull String id) {
        DistributionPackage distributionPackage = SimpleDistributionPackage.fromIdString(id, this.type);
        if (distributionPackage == null) {
            if (id.startsWith("reference")) {
                String localId = id.substring("reference-".length());
                distributionPackage = new ReferencePackage(this.getPackageInternal(resourceResolver, localId));
            } else {
                distributionPackage = this.getPackageInternal(resourceResolver, id);
            }
        }
        return distributionPackage;
    }

    private Session getSession(ResourceResolver resourceResolver) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new RepositoryException("could not obtain a session from calling user " + resourceResolver.getUserID());
        }
        DistributionJcrUtils.setDoNotDistribute(session);
        return session;
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
            catch (RepositoryException e) {
                this.log.debug("Cannot save session", (Throwable)e);
            }
        }
    }

    @CheckForNull
    protected abstract DistributionPackage createPackageForAdd(@Nonnull ResourceResolver var1, @Nonnull DistributionRequest var2) throws DistributionException;

    @CheckForNull
    protected abstract DistributionPackage readPackageInternal(@Nonnull ResourceResolver var1, @Nonnull InputStream var2) throws DistributionException;

    protected abstract boolean installPackageInternal(@Nonnull ResourceResolver var1, @Nonnull InputStream var2) throws DistributionException;

    @CheckForNull
    protected abstract DistributionPackage getPackageInternal(@Nonnull ResourceResolver var1, @Nonnull String var2);
}

