/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.monitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Apache Sling Distribution Queue Health Check")
@Properties(value={@Property(name="hc.name", value={"SlingDistributionQueueHC"}, description="Health Check name", label="Name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY, description="Health Check tags", label="Tags"), @Property(name="hc.mbean.name", value={"slingDistributionQueue"}, description="Health Check MBean name", label="MBean name")})
@References(value={@Reference(name="distributionAgent", referenceInterface=DistributionAgent.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
@Service(value={HealthCheck.class})
public class DistributionQueueHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(DistributionQueueHealthCheck.class);
    private static final int DEFAULT_NUMBER_OF_RETRIES_ALLOWED = 3;
    private int numberOfRetriesAllowed;
    @Property(intValue={3}, description="Number of allowed retries", label="Allowed retries")
    private static final String NUMBER_OF_RETRIES_ALLOWED = "numberOfRetriesAllowed";
    private final List<DistributionAgent> distributionAgents = new CopyOnWriteArrayList<DistributionAgent>();

    @Activate
    public void activate(Map<String, Object> properties) {
        this.numberOfRetriesAllowed = PropertiesUtil.toInteger((Object)properties.get(NUMBER_OF_RETRIES_ALLOWED), (int)3);
        log.info("Activated, numberOfRetriesAllowed={}", (Object)this.numberOfRetriesAllowed);
    }

    @Deactivate
    protected void deactivate() {
        this.distributionAgents.clear();
    }

    void bindDistributionAgent(DistributionAgent distributionAgent) {
        this.distributionAgents.add(distributionAgent);
        log.debug("Registering distribution agent {} ", (Object)distributionAgent);
    }

    protected void unbindDistributionAgent(DistributionAgent distributionAgent) {
        this.distributionAgents.remove(distributionAgent);
        log.debug("Unregistering distribution agent {} ", (Object)distributionAgent);
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        HashMap<String, Integer> failures = new HashMap<String, Integer>();
        if (this.distributionAgents.size() > 0) {
            for (DistributionAgent distributionAgent : this.distributionAgents) {
                for (String queueName : distributionAgent.getQueueNames()) {
                    try {
                        DistributionQueue q = distributionAgent.getQueue(queueName);
                        DistributionQueueEntry entry = q.getHead();
                        if (entry != null) {
                            DistributionQueueItemStatus status = entry.getStatus();
                            if (status.getAttempts() <= this.numberOfRetriesAllowed) {
                                resultLog.debug("Queue: [{}], first item: [{}], number of retries: {}", new Object[]{q.getName(), entry.getId(), status.getAttempts()});
                                continue;
                            }
                            resultLog.warn("Queue: [{}], first item: [{}], number of retries: {}, expected number of retries <= {}", new Object[]{q.getName(), entry.getId(), status.getAttempts(), this.numberOfRetriesAllowed});
                            failures.put(q.getName(), status.getAttempts());
                            continue;
                        }
                        resultLog.debug("No items in queue [{}]", new Object[]{q.getName()});
                    }
                    catch (Exception e) {
                        resultLog.warn("Exception while inspecting distribution queue [{}]: {}", new Object[]{queueName, e});
                    }
                }
            }
        } else {
            resultLog.debug("No distribution queue providers found", new Object[0]);
        }
        if (failures.size() > 0) {
            for (Map.Entry entry : failures.entrySet()) {
                resultLog.warn("Distribution queue {}'s first item in the default queue has been retried {} times (threshold: {})", new Object[]{entry.getKey(), entry.getValue(), this.numberOfRetriesAllowed});
            }
        }
        return new Result((ResultLog)resultLog);
    }
}

