/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.log.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.log.DistributionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class DefaultDistributionLog
implements DistributionLog {
    private final DistributionComponentKind kind;
    private final String name;
    private final LinkedList<String> lines = new LinkedList();
    private final Logger logger;
    private final LogLevel logLevel;

    public DefaultDistributionLog(DistributionComponentKind kind, String name, Class<?> clazz, LogLevel logLevel) {
        this.kind = kind;
        this.name = name;
        this.logLevel = logLevel;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public String getName() {
        return this.name;
    }

    public DistributionComponentKind getKind() {
        return this.kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLines() {
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            return new ArrayList<String>(this.lines);
        }
    }

    private void internalLog(LogLevel level, String fmt, Object ... objects) {
        try {
            FormattingTuple fmtp = MessageFormatter.arrayFormat((String)fmt, (Object[])objects);
            this.internalLog(level, fmtp.getMessage());
        }
        catch (Throwable e) {
            this.logger.error("cannot add entry log", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalLog(LogLevel level, String message) {
        if (level.cardinal < this.logLevel.cardinal) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        Calendar cal = Calendar.getInstance();
        String log = dateFormat.format(cal.getTime()) + " - " + level.name() + " - " + message;
        LinkedList<String> linkedList = this.lines;
        synchronized (linkedList) {
            this.lines.add(log);
            int maxLines = 1000;
            while (this.lines.size() > maxLines) {
                this.lines.removeFirst();
            }
        }
    }

    public void error(String fmt, Object ... objects) {
        String specificFmt = this.getSpecificString(fmt);
        this.logger.error(specificFmt, objects);
        this.internalLog(LogLevel.ERROR, fmt, objects);
    }

    public void info(String fmt, Object ... objects) {
        String specificFmt = this.getSpecificString(fmt);
        this.logger.info(specificFmt, objects);
        this.internalLog(LogLevel.INFO, fmt, objects);
    }

    public void info(boolean silent, String fmt, Object ... objects) {
        if (silent) {
            this.debug(fmt, objects);
        } else {
            this.info(fmt, objects);
        }
    }

    public void debug(String fmt, Object ... objects) {
        String specificFmt = this.getSpecificString(fmt);
        this.logger.debug(specificFmt, objects);
        this.internalLog(LogLevel.DEBUG, fmt, objects);
    }

    public void warn(String fmt, Object ... objects) {
        String specificFmt = this.getSpecificString(fmt);
        this.logger.warn(specificFmt, objects);
        this.internalLog(LogLevel.WARN, fmt, objects);
    }

    private String getSpecificString(String fmt) {
        return "[" + this.kind.getName() + "][" + this.name + "] " + fmt;
    }

    public static enum LogLevel {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3);

        public final int cardinal;

        private LogLevel(int cardinal) {
            this.cardinal = cardinal;
        }
    }
}

