/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.impl;

import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Distributor.class})
public class DefaultDistributor
implements Distributor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DistributionComponentProvider componentProvider;

    @Nonnull
    public DistributionResponse distribute(@Nonnull String agentName, @Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest) {
        DistributionAgent agent = this.componentProvider.getService(DistributionAgent.class, agentName);
        if (agent == null) {
            return new SimpleDistributionResponse(DistributionRequestState.NOT_EXECUTED, "Agent is not available");
        }
        try {
            return agent.execute(resourceResolver, distributionRequest);
        }
        catch (DistributionException e) {
            this.log.error("cannot execute", (Throwable)e);
            return new SimpleDistributionResponse(DistributionRequestState.DROPPED, "Cannot execute request " + e.getMessage());
        }
    }

    protected void bindComponentProvider(DistributionComponentProvider distributionComponentProvider) {
        this.componentProvider = distributionComponentProvider;
    }

    protected void unbindComponentProvider(DistributionComponentProvider distributionComponentProvider) {
        if (this.componentProvider == distributionComponentProvider) {
            this.componentProvider = null;
        }
    }
}

