/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.event.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DistributionEventFactory.class})
public class DefaultDistributionEventFactory
implements DistributionEventFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EventAdmin eventAdmin;

    private void generateEvent(@Nonnull String distributionEventTopic, @Nonnull Dictionary<?, ?> properties) {
        this.eventAdmin.postEvent(new Event(distributionEventTopic, properties));
        this.log.debug("distribution event {} posted", (Object)distributionEventTopic);
    }

    @Override
    public void generatePackageEvent(@Nonnull String distributionEventTopic, @Nonnull DistributionComponentKind kind, @Nonnull String name, @Nonnull DistributionPackageInfo info) {
        try {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            ((Dictionary)dictionary).put("distribution.component.name", name);
            ((Dictionary)dictionary).put("distribution.component.kind", kind.name());
            if (info.getRequestType() != null) {
                ((Dictionary)dictionary).put("distribution.type", info.getRequestType());
            }
            if (info.getPaths() != null) {
                ((Dictionary)dictionary).put("distribution.paths", info.getPaths());
            }
            this.generateEvent(distributionEventTopic, dictionary);
        }
        catch (Throwable e) {
            this.log.error("Cannot generate package event", e);
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

