/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionConfiguration;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.resources.impl.OsgiUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiConfigurationManager
implements DistributionConfigurationManager {
    private final ConfigurationAdmin configurationAdmin;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public OsgiConfigurationManager(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public List<DistributionConfiguration> getConfigs(ResourceResolver resolver, DistributionComponentKind kind) {
        List<Configuration> configurations = this.getOsgiConfigurations(kind, null);
        ArrayList<DistributionConfiguration> result = new ArrayList<DistributionConfiguration>();
        if (configurations == null || configurations.isEmpty()) {
            return result;
        }
        for (Configuration configuration : configurations) {
            Dictionary propertiesDict = configuration.getProperties();
            Map<String, Object> properties = OsgiUtils.fromDictionary(propertiesDict);
            properties = this.filterBeforeRead(properties);
            String name = PropertiesUtil.toString((Object)properties.get("name"), null);
            result.add(new DistributionConfiguration(kind, name, properties));
        }
        return result;
    }

    @Override
    public DistributionConfiguration getConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        Configuration configuration;
        List<Configuration> configurations = this.getOsgiConfigurations(kind, name);
        if (configurations == null || configurations.isEmpty()) {
            return null;
        }
        if (configurations.size() > 1) {
            this.log.warn("Found more than one configuration of kind: {} and with name: {}", (Object[])new String[]{kind.getName(), name});
        }
        if ((configuration = configurations.get(0)) != null) {
            Dictionary properties = configuration.getProperties();
            Map<String, Object> result = OsgiUtils.fromDictionary(properties);
            String factoryPid = PropertiesUtil.toString(result.get("service.factoryPid"), null);
            String type = kind.getType(factoryPid);
            result.put("type", type);
            result = this.filterBeforeRead(result);
            return new DistributionConfiguration(kind, name, result);
        }
        return null;
    }

    @Override
    public void saveConfig(ResourceResolver resolver, DistributionConfiguration config) {
        String componentName = config.getName();
        DistributionComponentKind componentKind = config.getKind();
        Map<String, Object> properties = config.getProperties();
        String componentType = PropertiesUtil.toString((Object)properties.get("type"), null);
        if (componentKind == null || componentType == null) {
            throw new IllegalArgumentException("kind and type are required " + (Object)((Object)componentKind) + componentType);
        }
        String factoryPid = componentKind.getFactory(componentType);
        if (factoryPid != null) {
            List<Configuration> configs = this.getOsgiConfigurations(componentKind, componentName);
            Iterator<Configuration> iter = configs.iterator();
            while (iter.hasNext()) {
                Configuration conf = iter.next();
                if (!factoryPid.equals(conf.getFactoryPid())) continue;
                iter.remove();
            }
            this.deleteOsgiConfigs(configs);
            properties.put("name", componentName);
            this.saveOsgiConfig(factoryPid, componentName, properties);
        }
    }

    @Override
    public void deleteConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        List<Configuration> configs = this.getOsgiConfigurations(kind, name);
        this.deleteOsgiConfigs(configs);
        this.log.info("Delete component {}", (Object)name);
    }

    private void deleteOsgiConfigs(List<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            String pid = configuration.getPid();
            try {
                configuration.delete();
                this.log.info("Deleted configuration {}", (Object)pid);
            }
            catch (IOException e) {
                this.log.warn("Cannot delete configuration {}", (Object)pid, (Object)e);
            }
        }
    }

    private List<Configuration> getOsgiConfigurations(DistributionComponentKind kind, String componentName) {
        List<String> factoryPids = kind.getFactories();
        ArrayList<Configuration> allConfigurations = new ArrayList<Configuration>();
        for (String factoryPid : factoryPids) {
            List<Configuration> configurations = this.getOsgiConfigurationsFromFactory(factoryPid, componentName);
            allConfigurations.addAll(configurations);
        }
        return allConfigurations;
    }

    private Configuration saveOsgiConfig(String factoryPid, String componentName, Map<String, Object> properties) {
        try {
            List<Configuration> configurations = this.getOsgiConfigurationsFromFactory(factoryPid, componentName);
            Configuration configuration = null;
            configuration = configurations == null || configurations.isEmpty() ? this.configurationAdmin.createFactoryConfiguration(factoryPid) : configurations.get(0);
            properties = this.filterBeforeSave(properties);
            configuration.update(OsgiUtils.toDictionary(properties));
            return configuration;
        }
        catch (IOException e) {
            this.log.error("Cannot create configuration with factory {}", (Object)factoryPid, (Object)e);
            return null;
        }
    }

    private List<Configuration> getOsgiConfigurationsFromFactory(String factoryPid, String componentName) {
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        try {
            String filter = OsgiUtils.getFilter(factoryPid, "name", componentName);
            Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
            if (configurations != null) {
                result.addAll(Arrays.asList(configurations));
            }
        }
        catch (IOException e) {
            this.log.error("cannot get osgi configs", (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            this.log.error("cannot parse filter", (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> filterBeforeSave(Map<String, Object> properties) {
        Map<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getKey().endsWith(".target")) {
                String entryValue = (String)entry.getValue();
                if ((entryValue = this.packOsgiFilter(entryValue)) == null) continue;
                result.put(entry.getKey(), entryValue);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        result = OsgiUtils.sanitize(result);
        return result;
    }

    private Map<String, Object> filterBeforeRead(Map<String, Object> properties) {
        Map<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getKey().endsWith(".target")) {
                String entryValue = (String)entry.getValue();
                if ((entryValue = this.unpackOsgiFilter(entryValue)) == null) continue;
                result.put(entry.getKey(), entryValue);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        result = OsgiUtils.sanitize(result);
        return result;
    }

    private String unpackOsgiFilter(String propertyValue) {
        String result = null;
        String namePattern = "\\(name=(.*?)\\)";
        Pattern r = Pattern.compile(namePattern);
        Matcher m = r.matcher(propertyValue);
        if (m.matches()) {
            result = m.group(1);
        }
        return result;
    }

    private String packOsgiFilter(String propertyValue) {
        return "(name=" + OsgiUtils.escape(propertyValue) + ")";
    }
}

