/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.ForwardDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.PrivilegeDistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.QueueDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.ReverseDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.SyncDistributionAgentFactory;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.exporter.AgentDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.importer.LocalDistributionPackageImporterFactory;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporterFactory;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.serialization.impl.vlt.VaultDistributionPackageBuilderFactory;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.UserCredentialsDistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.DistributionEventDistributeDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.JcrEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.PersistedJcrEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.ResourceEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.ScheduledDistributionTriggerFactory;

public enum DistributionComponentKind {
    AGENT("agent", "sling/distribution/service/agent", "sling/distribution/service/agent/list", DistributionAgent.class, new HashMap<String, Class<?>>(){
        {
            this.put("simple", SimpleDistributionAgentFactory.class);
            this.put("sync", SyncDistributionAgentFactory.class);
            this.put("forward", ForwardDistributionAgentFactory.class);
            this.put("reverse", ReverseDistributionAgentFactory.class);
            this.put("queue", QueueDistributionAgentFactory.class);
        }
    }),
    IMPORTER("importer", "sling/distribution/service/importer", "sling/distribution/service/importer/list", DistributionPackageImporter.class, new HashMap<String, Class<?>>(){
        {
            this.put("local", LocalDistributionPackageImporterFactory.class);
            this.put("remote", RemoteDistributionPackageImporterFactory.class);
        }
    }),
    EXPORTER("exporter", "sling/distribution/service/exporter", "sling/distribution/service/exporter/list", DistributionPackageExporter.class, new HashMap<String, Class<?>>(){
        {
            this.put("local", LocalDistributionPackageExporterFactory.class);
            this.put("remote", RemoteDistributionPackageExporterFactory.class);
            this.put("agent", AgentDistributionPackageExporterFactory.class);
        }
    }),
    QUEUE_PROVIDER("queueProvider", "sling/distribution/service", "sling/distribution/service", DistributionQueueProvider.class, new HashMap<String, Class<?>>(){
        {
            this.put("simple", SimpleDistributionAgentFactory.class);
            this.put("sync", SyncDistributionAgentFactory.class);
            this.put("forward", ForwardDistributionAgentFactory.class);
            this.put("reverse", ReverseDistributionAgentFactory.class);
            this.put("queue", QueueDistributionAgentFactory.class);
        }
    }),
    QUEUE_STRATEGY("queueStrategy", "sling/distribution/service", "sling/distribution/service", DistributionQueueDispatchingStrategy.class, new HashMap<String, Class<?>>(){
        {
            this.put("simple", SimpleDistributionAgentFactory.class);
            this.put("sync", SyncDistributionAgentFactory.class);
            this.put("forward", ForwardDistributionAgentFactory.class);
            this.put("reverse", ReverseDistributionAgentFactory.class);
            this.put("queue", QueueDistributionAgentFactory.class);
        }
    }),
    TRANSPORT_SECRET_PROVIDER("transportSecretProvider", "sling/distribution/service", "sling/distribution/service", DistributionTransportSecretProvider.class, new HashMap<String, Class<?>>(){
        {
            this.put("user", UserCredentialsDistributionTransportSecretProvider.class);
        }
    }),
    PACKAGE_BUILDER("packageBuilder", "sling/distribution/service", "sling/distribution/service", DistributionPackageBuilder.class, new HashMap<String, Class<?>>(){
        {
            this.put("filevlt", VaultDistributionPackageBuilderFactory.class);
            this.put("jcrvlt", VaultDistributionPackageBuilderFactory.class);
        }
    }),
    REQUEST_AUTHORIZATION("requestAuthorization", "sling/distribution/service", "sling/distribution/service", DistributionRequestAuthorizationStrategy.class, new HashMap<String, Class<?>>(){
        {
            this.put("privilege", PrivilegeDistributionRequestAuthorizationStrategy.class);
        }
    }),
    TRIGGER("trigger", "sling/distribution/service/trigger", "sling/distribution/service/trigger/list", DistributionTrigger.class, new HashMap<String, Class<?>>(){
        {
            this.put("resourceEvent", ResourceEventDistributionTriggerFactory.class);
            this.put("scheduledEvent", ScheduledDistributionTriggerFactory.class);
            this.put("distributionEvent", DistributionEventDistributeDistributionTriggerFactory.class);
            this.put("persistedJcrEvent", PersistedJcrEventDistributionTriggerFactory.class);
            this.put("jcrEvent", JcrEventDistributionTriggerFactory.class);
        }
    });

    private final String name;
    private final String resourceType;
    private final String rootResourceType;
    private final Class<?> type;
    private final Map<String, Class<?>> factoryMap;

    private DistributionComponentKind(String name, String resourceType, String rootResourceType, Class<?> type, Map<String, Class<?>> factoryMap) {
        this.name = name;
        this.resourceType = resourceType;
        this.rootResourceType = rootResourceType;
        this.type = type;
        this.factoryMap = factoryMap;
    }

    public Class<?> asClass() {
        return this.type;
    }

    public static DistributionComponentKind fromClass(Class<?> type) {
        for (DistributionComponentKind kind : DistributionComponentKind.values()) {
            Class<?> kindClass = kind.asClass();
            if (!kindClass.equals(type)) continue;
            return kind;
        }
        return null;
    }

    public static DistributionComponentKind fromName(String name) {
        for (DistributionComponentKind kind : DistributionComponentKind.values()) {
            if (!kind.getName().equals(name)) continue;
            return kind;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getRootResourceType() {
        return this.rootResourceType;
    }

    public String getFactory(String type) {
        Class<?> factory = this.factoryMap.get(type);
        if (factory != null) {
            return factory.getName();
        }
        return null;
    }

    public List<String> getFactories() {
        ArrayList<String> result = new ArrayList<String>();
        for (Class<?> factory : this.factoryMap.values()) {
            result.add(factory.getName());
        }
        return result;
    }

    public String getType(String factory) {
        for (Map.Entry<String, Class<?>> factoryEntry : this.factoryMap.entrySet()) {
            String type = factoryEntry.getKey();
            Class<?> factoryClass = factoryEntry.getValue();
            if (!factoryClass.getName().equals(factory)) continue;
            return type;
        }
        return null;
    }
}

