/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionConfiguration;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.component.impl.OsgiConfigurationManager;
import org.apache.sling.distribution.component.impl.ResourceConfigurationManager;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={DistributionConfigurationManager.class})
public class DefaultDistributionConfigurationManager
implements DistributionConfigurationManager {
    @Property(label="Resource Config Enabled", description="If storing config in resource tree is enabled.", boolValue={false})
    public static final String CONFIG_ENABLED = "resource.config.enabled";
    @Property(label="Resource Config Prefix", description="The prefix of properties to be stored in content", value={"etc."})
    public static final String CONFIG_PREFIX = "resource.config.prefix";
    @Property(label="Resource Config Root", description="The resource config root", value={"/etc/distribution"})
    public static final String CONFIG_ROOT = "resource.config.root";
    @Property(label="Resource Config Properties", description="The resource config properties", value={"enabled"})
    public static final String CONFIG_PROPERTIES = "resource.config.properties";
    @Property(label="Resource Config Defaults", description="The default values for resource config properties", value={"serializationType=distribution"})
    public static final String CONFIG_DEFAULTS = "resource.config.defaults";
    @Reference
    ConfigurationAdmin configurationAdmin;
    private DistributionConfigurationManager osgiManager;
    private DistributionConfigurationManager resourceManager;
    static String resourcePrefix;
    static final String OSGI_PREFIX = "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    void activate(Map<String, Object> properties) {
        boolean configEnabled = PropertiesUtil.toBoolean((Object)properties.get(CONFIG_ENABLED), (boolean)false);
        String configRoot = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)properties.get(CONFIG_ROOT), null));
        resourcePrefix = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)properties.get(CONFIG_PREFIX), null));
        String[] configProperties = SettingsUtils.removeEmptyEntries(PropertiesUtil.toStringArray((Object)properties.get(CONFIG_PROPERTIES), null));
        if (configEnabled && configRoot != null && configProperties != null) {
            Map configDefaults = PropertiesUtil.toMap((Object)properties.get(CONFIG_DEFAULTS), (String[])new String[0]);
            this.resourceManager = new ResourceConfigurationManager(configRoot, configProperties, configDefaults);
        }
        this.osgiManager = new OsgiConfigurationManager(this.configurationAdmin);
    }

    @Deactivate
    void deactivate() {
        this.resourceManager = null;
        this.osgiManager = null;
    }

    @Override
    public List<DistributionConfiguration> getConfigs(ResourceResolver resolver, DistributionComponentKind kind) {
        List<DistributionConfiguration> result = this.osgiManager.getConfigs(resolver, kind);
        if (this.resourceManager != null) {
            List<DistributionConfiguration> resourceConfigs = this.resourceManager.getConfigs(resolver, kind);
            result = DefaultDistributionConfigurationManager.mergeConfigs(result, resourceConfigs, resourcePrefix);
        }
        return result;
    }

    @Override
    public DistributionConfiguration getConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        DistributionConfiguration resultConfig = this.osgiManager.getConfig(resolver, kind, name);
        if (this.resourceManager != null) {
            DistributionConfiguration resourceConfig = this.resourceManager.getConfig(resolver, kind, name);
            resultConfig = DefaultDistributionConfigurationManager.mergeConfig(resultConfig, resourceConfig, resourcePrefix);
        }
        return resultConfig;
    }

    @Override
    public void saveConfig(ResourceResolver resolver, DistributionConfiguration config) {
        this.log.debug("saving config {}", (Object)config);
        if (this.resourceManager != null) {
            Map<String, DistributionConfiguration> splitConfig = DefaultDistributionConfigurationManager.splitConfig(config, resourcePrefix);
            DistributionConfiguration defaultConfig = splitConfig.get(OSGI_PREFIX);
            this.osgiManager.saveConfig(resolver, defaultConfig);
            DistributionConfiguration resourceConfig = splitConfig.get(resourcePrefix);
            this.log.debug("retrieved config {}", (Object)resourceConfig);
            if (resourceConfig != null) {
                this.resourceManager.saveConfig(resolver, resourceConfig);
                this.log.debug("saved resource config: {}", (Object)resourceConfig);
            }
        } else {
            this.osgiManager.saveConfig(resolver, config);
            this.log.debug("saved osgi config: {}", (Object)config);
        }
    }

    @Override
    public void deleteConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        this.osgiManager.deleteConfig(resolver, kind, name);
        if (this.resourceManager != null) {
            this.resourceManager.deleteConfig(resolver, kind, name);
        }
    }

    static DistributionConfiguration mergeConfig(DistributionConfiguration main, DistributionConfiguration extension, String prefix) {
        if (main == null) {
            return null;
        }
        HashMap<String, DistributionConfiguration> configMap = new HashMap<String, DistributionConfiguration>();
        configMap.put(OSGI_PREFIX, main);
        configMap.put(prefix, extension);
        return DefaultDistributionConfigurationManager.mergeConfig(main.getKind(), main.getName(), configMap);
    }

    static DistributionConfiguration mergeConfig(DistributionComponentKind kind, String name, Map<String, DistributionConfiguration> configMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String prefixKey : configMap.keySet()) {
            DistributionConfiguration config = configMap.get(prefixKey);
            if (config == null) continue;
            Map<String, Object> properties = config.getProperties();
            if (prefixKey.equals(OSGI_PREFIX)) {
                result.putAll(properties);
                continue;
            }
            for (String propertyKey : properties.keySet()) {
                Object propertyValue = properties.get(propertyKey);
                result.put(prefixKey + propertyKey, propertyValue);
            }
        }
        return new DistributionConfiguration(kind, name, result);
    }

    static List<DistributionConfiguration> mergeConfigs(List<DistributionConfiguration> target, List<DistributionConfiguration> source, String prefix) {
        ArrayList<DistributionConfiguration> result = new ArrayList<DistributionConfiguration>();
        HashMap<String, DistributionConfiguration> sourceMap = new HashMap<String, DistributionConfiguration>();
        for (DistributionConfiguration config : source) {
            sourceMap.put(config.getName(), config);
        }
        for (DistributionConfiguration targetConfig : target) {
            DistributionConfiguration sourceConfig = (DistributionConfiguration)sourceMap.get(targetConfig.getName());
            DistributionConfiguration mergedConfig = DefaultDistributionConfigurationManager.mergeConfig(targetConfig, sourceConfig, prefix);
            result.add(mergedConfig);
        }
        return result;
    }

    private static Map<String, DistributionConfiguration> splitConfig(DistributionConfiguration config, String prefix) {
        Map<String, Object> distributionConfigurationProperties = config.getProperties();
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        HashMap<String, Object> prefixMap = new HashMap<String, Object>();
        for (String configurationPropertyKey : distributionConfigurationProperties.keySet()) {
            if (configurationPropertyKey.startsWith(prefix)) {
                prefixMap.put(configurationPropertyKey.substring(prefix.length()), distributionConfigurationProperties.get(configurationPropertyKey));
                continue;
            }
            defaultMap.put(configurationPropertyKey, distributionConfigurationProperties.get(configurationPropertyKey));
        }
        HashMap<String, DistributionConfiguration> result = new HashMap<String, DistributionConfiguration>();
        result.put(OSGI_PREFIX, new DistributionConfiguration(config.getKind(), config.getName(), defaultMap));
        if (prefixMap.size() > 0) {
            result.put(prefix, new DistributionConfiguration(config.getKind(), config.getName(), prefixMap));
        }
        return result;
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }
}

