/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.component.impl.DistributionComponent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;

@Component
@Property(name="name", value={"default"})
@References(value={@Reference(name="distributionAgent", referenceInterface=DistributionAgent.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionPackageImporter", referenceInterface=DistributionPackageImporter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionPackageExporter", referenceInterface=DistributionPackageExporter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionQueueProvider", referenceInterface=DistributionQueueProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionQueueDistributionStrategy", referenceInterface=DistributionQueueDispatchingStrategy.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionTransportSecretProvider", referenceInterface=DistributionTransportSecretProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="distributionPackageBuilder", referenceInterface=DistributionPackageBuilder.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
@Service(value={DistributionComponentProvider.class})
public class DefaultDistributionComponentProvider
implements DistributionComponentProvider {
    private static final String NAME = "name";
    private final Map<String, DistributionComponent<DistributionAgent>> distributionAgentMap = new ConcurrentHashMap<String, DistributionComponent<DistributionAgent>>();
    private final Map<String, DistributionComponent<DistributionQueueProvider>> distributionQueueProviderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionQueueProvider>>();
    private final Map<String, DistributionComponent<DistributionQueueDispatchingStrategy>> distributionQueueDistributionStrategyMap = new ConcurrentHashMap<String, DistributionComponent<DistributionQueueDispatchingStrategy>>();
    private final Map<String, DistributionComponent<DistributionTransportSecretProvider>> distributionTransportSecretProviderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionTransportSecretProvider>>();
    private final Map<String, DistributionComponent<DistributionPackageImporter>> distributionPackageImporterMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageImporter>>();
    private final Map<String, DistributionComponent<DistributionPackageExporter>> distributionPackageExporterMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageExporter>>();
    private final Map<String, DistributionComponent<DistributionPackageBuilder>> distributionPackageBuilderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageBuilder>>();

    @Override
    public DistributionComponent<?> getComponent(DistributionComponentKind kind, String componentName) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(kind.asClass());
        return componentMap.get(componentName);
    }

    @Override
    public List<DistributionComponent<?>> getComponents(DistributionComponentKind kind) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(kind.asClass());
        ArrayList componentList = new ArrayList();
        componentList.addAll(componentMap.values());
        return componentList;
    }

    @Override
    public <ComponentType> ComponentType getService(Class<ComponentType> type, String componentName) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(type);
        DistributionComponent<?> component = componentMap.get(componentName);
        if (component == null) {
            return null;
        }
        return type.cast(component.getService());
    }

    private Map<String, DistributionComponent<?>> getComponentMap(Class<?> type) {
        if (type.isAssignableFrom(DistributionAgent.class)) {
            return this.distributionAgentMap;
        }
        if (type.isAssignableFrom(DistributionPackageExporter.class)) {
            return this.distributionPackageExporterMap;
        }
        if (type.isAssignableFrom(DistributionPackageImporter.class)) {
            return this.distributionPackageImporterMap;
        }
        if (type.isAssignableFrom(DistributionQueueProvider.class)) {
            return this.distributionQueueProviderMap;
        }
        if (type.isAssignableFrom(DistributionQueueDispatchingStrategy.class)) {
            return this.distributionQueueDistributionStrategyMap;
        }
        if (type.isAssignableFrom(DistributionTransportSecretProvider.class)) {
            return this.distributionTransportSecretProviderMap;
        }
        if (type.isAssignableFrom(DistributionPackageBuilder.class)) {
            return this.distributionPackageBuilderMap;
        }
        return null;
    }

    private void bindDistributionQueueProvider(DistributionQueueProvider distributionQueueProvider, Map<String, Object> config) {
        this.put(DistributionQueueProvider.class, distributionQueueProvider, config);
    }

    private void unbindDistributionQueueProvider(DistributionQueueProvider distributionQueueProvider, Map<String, Object> config) {
        this.remove(DistributionQueueProvider.class, distributionQueueProvider, config);
    }

    private void bindDistributionQueueDistributionStrategy(DistributionQueueDispatchingStrategy distributionQueueDispatchingStrategy, Map<String, Object> config) {
        this.put(DistributionQueueDispatchingStrategy.class, distributionQueueDispatchingStrategy, config);
    }

    private void unbindDistributionQueueDistributionStrategy(DistributionQueueDispatchingStrategy distributionQueueDispatchingStrategy, Map<String, Object> config) {
        this.remove(DistributionQueueDispatchingStrategy.class, distributionQueueDispatchingStrategy, config);
    }

    private void bindDistributionTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider, Map<String, Object> config) {
        this.put(DistributionTransportSecretProvider.class, distributionTransportSecretProvider, config);
    }

    private void unbindDistributionTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider, Map<String, Object> config) {
        this.remove(DistributionTransportSecretProvider.class, distributionTransportSecretProvider, config);
    }

    private void bindDistributionPackageImporter(DistributionPackageImporter distributionPackageImporter, Map<String, Object> config) {
        this.put(DistributionPackageImporter.class, distributionPackageImporter, config);
    }

    private void unbindDistributionPackageImporter(DistributionPackageImporter distributionPackageImporter, Map<String, Object> config) {
        this.remove(DistributionPackageImporter.class, distributionPackageImporter, config);
    }

    private void bindDistributionPackageExporter(DistributionPackageExporter distributionPackageExporter, Map<String, Object> config) {
        this.put(DistributionPackageExporter.class, distributionPackageExporter, config);
    }

    private void unbindDistributionPackageExporter(DistributionPackageExporter distributionPackageExporter, Map<String, Object> config) {
        this.remove(DistributionPackageExporter.class, distributionPackageExporter, config);
    }

    private void bindDistributionAgent(DistributionAgent distributionAgent, Map<String, Object> config) {
        this.put(DistributionAgent.class, distributionAgent, config);
    }

    private void unbindDistributionAgent(DistributionAgent distributionAgent, Map<String, Object> config) {
        this.remove(DistributionAgent.class, distributionAgent, config);
    }

    private void bindDistributionPackageBuilder(DistributionPackageBuilder distributionPackageBuilder, Map<String, Object> config) {
        this.put(DistributionPackageBuilder.class, distributionPackageBuilder, config);
    }

    private void unbindDistributionPackageBuilder(DistributionPackageBuilder distributionPackageBuilder, Map<String, Object> config) {
        this.remove(DistributionPackageBuilder.class, distributionPackageBuilder, config);
    }

    private <ComponentType> void put(Class<ComponentType> typeClass, ComponentType service, Map<String, Object> config) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(typeClass);
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        DistributionComponentKind kind = DistributionComponentKind.fromClass(typeClass);
        if (name != null && kind != null) {
            componentMap.put(name, new DistributionComponent<ComponentType>(kind, name, service, config));
        }
    }

    private <ComponentType> void remove(Class<ComponentType> typeClass, ComponentType service, Map<String, Object> config) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(typeClass);
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        if (name != null) {
            componentMap.remove(name);
        }
    }
}

