/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentAuthenticationInfo;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.util.impl.DistributionUtils;

class TriggerAgentRequestHandler
implements DistributionRequestHandler {
    private final SimpleDistributionAgentAuthenticationInfo authenticationInfo;
    private final DefaultDistributionLog log;
    private final boolean active;
    private final DistributionAgent agent;

    public TriggerAgentRequestHandler(@Nonnull DistributionAgent agent, @Nonnull SimpleDistributionAgentAuthenticationInfo authenticationInfo, @Nonnull DefaultDistributionLog log, boolean active) {
        this.authenticationInfo = authenticationInfo;
        this.log = log;
        this.active = active;
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(@Nullable ResourceResolver resourceResolver, @Nonnull DistributionRequest request) {
        if (!this.active) {
            this.log.warn("skipping agent handler as agent is disabled", new Object[0]);
            return;
        }
        if (resourceResolver != null) {
            try {
                this.agent.execute(resourceResolver, request);
                return;
            }
            catch (Throwable t) {
                this.log.error("Error executing handler {}", request, t);
                return;
            }
        }
        ResourceResolver agentResourceResolver = null;
        try {
            agentResourceResolver = DistributionUtils.getResourceResolver(null, this.authenticationInfo.getAgentService(), this.authenticationInfo.getSlingRepository(), this.authenticationInfo.getSubServiceName(), this.authenticationInfo.getResourceResolverFactory());
            this.agent.execute(agentResourceResolver, request);
        }
        catch (Throwable e) {
            try {
                this.log.error("Error executing handler {}", request, e);
            }
            catch (Throwable throwable) {
                DistributionUtils.ungetResourceResolver(agentResourceResolver);
                throw throwable;
            }
            DistributionUtils.ungetResourceResolver(agentResourceResolver);
            return;
        }
        DistributionUtils.ungetResourceResolver(agentResourceResolver);
        return;
    }
}

