/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentAuthenticationInfo;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.common.RecoverableDistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleDistributionAgentQueueProcessor
implements DistributionQueueProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionPackageExporter distributionPackageExporter;
    private final DistributionPackageImporter distributionPackageImporter;
    private final int retryAttempts;
    private final DistributionQueueDispatchingStrategy errorQueueStrategy;
    private final DefaultDistributionLog distributionLog;
    private final DistributionQueueProvider queueProvider;
    private final DistributionEventFactory distributionEventFactory;
    private final SimpleDistributionAgentAuthenticationInfo authenticationInfo;
    private final String agentName;

    public SimpleDistributionAgentQueueProcessor(DistributionPackageExporter distributionPackageExporter, DistributionPackageImporter distributionPackageImporter, int retryAttempts, DistributionQueueDispatchingStrategy errorQueueStrategy, DefaultDistributionLog log, DistributionQueueProvider queueProvider, DistributionEventFactory distributionEventFactory, SimpleDistributionAgentAuthenticationInfo authenticationInfo, String agentName) {
        this.distributionPackageExporter = distributionPackageExporter;
        this.distributionPackageImporter = distributionPackageImporter;
        this.retryAttempts = retryAttempts;
        this.errorQueueStrategy = errorQueueStrategy;
        this.distributionLog = log;
        this.queueProvider = queueProvider;
        this.distributionEventFactory = distributionEventFactory;
        this.authenticationInfo = authenticationInfo;
        this.agentName = agentName;
    }

    @Override
    public boolean process(@Nonnull String queueName, @Nonnull DistributionQueueEntry queueEntry) {
        DistributionQueueItem queueItem = queueEntry.getItem();
        try {
            long startTime = System.currentTimeMillis();
            this.distributionLog.debug("[{}] ITEM-PROCESS processing item={}", new Object[]{queueName, queueItem});
            boolean success = this.processQueueItem(queueName, queueEntry);
            long endTime = System.currentTimeMillis();
            this.distributionLog.debug("[{}] ITEM-PROCESSED item={}, status={}, processingTime={}ms", new Object[]{queueName, queueItem, success, endTime - startTime});
            return success;
        }
        catch (Throwable t) {
            this.distributionLog.error("[{}] ITEM-FAIL item={}", new Object[]{queueName, queueItem, t});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueueItem(String queueName, DistributionQueueEntry queueEntry) throws DistributionException {
        ResourceResolver agentResourceResolver;
        boolean removeItemFromQueue;
        block11: {
            DistributionPackage distributionPackage;
            block10: {
                removeItemFromQueue = false;
                agentResourceResolver = null;
                distributionPackage = null;
                DistributionQueueItem queueItem = queueEntry.getItem();
                DistributionQueueItemStatus queueItemStatus = queueEntry.getStatus();
                try {
                    String callingUser = (String)queueItem.get("internal.request.user", String.class);
                    String requestId = (String)queueItem.get("internal.request.id", String.class);
                    Long globalStartTime = (Long)queueItem.get("internal.request.startTime", Long.class);
                    agentResourceResolver = DistributionUtils.getResourceResolver(callingUser, this.authenticationInfo.getAgentService(), this.authenticationInfo.getSlingRepository(), this.authenticationInfo.getSubServiceName(), this.authenticationInfo.getResourceResolverFactory());
                    long startTime = System.currentTimeMillis();
                    distributionPackage = this.distributionPackageExporter.getPackage(agentResourceResolver, queueItem.getPackageId());
                    if (distributionPackage != null) {
                        long packageSize = distributionPackage.getSize();
                        DistributionPackageUtils.mergeQueueEntry(distributionPackage.getInfo(), queueEntry);
                        DistributionRequestType requestType = distributionPackage.getInfo().getRequestType();
                        String[] paths = distributionPackage.getInfo().getPaths();
                        try {
                            this.distributionPackageImporter.importPackage(agentResourceResolver, distributionPackage);
                            this.distributionEventFactory.generatePackageEvent("org/apache/sling/distribution/agent/package/distributed", DistributionComponentKind.AGENT, this.agentName, distributionPackage.getInfo());
                            removeItemFromQueue = true;
                            long endTime = System.currentTimeMillis();
                            this.distributionLog.info("[{}] PACKAGE-DELIVERED {}: {} paths={}, importTime={}ms, execTime={}ms, size={}B", queueName, requestId, requestType, paths, endTime - startTime, endTime - globalStartTime, packageSize);
                        }
                        catch (RecoverableDistributionException e) {
                            this.distributionLog.error("[{}] PACKAGE-FAIL {}: could not deliver {}, {}", queueName, requestId, distributionPackage.getId(), e.getMessage());
                            this.distributionLog.debug("could not deliver package {}", distributionPackage.getId(), e);
                            this.log.error("could not deliver package {}", (Object)distributionPackage.getId(), (Object)e);
                        }
                        catch (Throwable e) {
                            this.distributionLog.error("[{}] PACKAGE-FAIL {}: could not deliver package {} {}", queueName, requestId, distributionPackage.getId(), e.getMessage(), e);
                            this.log.error("could not deliver package {} from queue {}", (Object)new Object[]{distributionPackage.getId(), queueName}, (Object)e);
                            if (this.errorQueueStrategy != null && queueItemStatus.getAttempts() > this.retryAttempts) {
                                removeItemFromQueue = this.reEnqueuePackage(distributionPackage);
                                this.distributionLog.info("[{}] PACKAGE-QUEUED {}: distribution package {} was enqueued to an error queue", queueName, requestId, distributionPackage.getId());
                            }
                        }
                    } else {
                        removeItemFromQueue = true;
                        this.distributionLog.error("distribution package with id {} does not exist. the package will be skipped.", queueItem.getPackageId());
                    }
                    if (!removeItemFromQueue) break block10;
                }
                catch (Throwable throwable) {
                    if (removeItemFromQueue) {
                        DistributionPackageUtils.releaseOrDelete(distributionPackage, queueName);
                    } else {
                        DistributionPackageUtils.closeSafely(distributionPackage);
                    }
                    DistributionUtils.ungetResourceResolver(agentResourceResolver);
                    throw throwable;
                }
                DistributionPackageUtils.releaseOrDelete(distributionPackage, queueName);
                break block11;
            }
            DistributionPackageUtils.closeSafely(distributionPackage);
        }
        DistributionUtils.ungetResourceResolver(agentResourceResolver);
        return removeItemFromQueue;
    }

    private boolean reEnqueuePackage(DistributionPackage distributionPackage) {
        if (this.errorQueueStrategy == null) {
            return false;
        }
        try {
            this.errorQueueStrategy.add(distributionPackage, this.queueProvider);
            this.log.warn("package {} moved to error queue", (Object)distributionPackage.getId());
        }
        catch (DistributionException e) {
            this.distributionLog.error("could not reenqueue package {}", distributionPackage.getId(), e);
            return false;
        }
        return true;
    }
}

