/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.agent.DistributionAgentState;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.ImportingDistributionPackageProcessor;
import org.apache.sling.distribution.agent.impl.QueueingDistributionPackageProcessor;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentAuthenticationInfo;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentQueueProcessor;
import org.apache.sling.distribution.agent.impl.TriggerAgentRequestHandler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.impl.CompositeDistributionResponse;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.apache.sling.distribution.log.DistributionLog;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.DistributionPackageProcessor;
import org.apache.sling.distribution.queue.DistributionQueue;
import org.apache.sling.distribution.queue.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.SimpleAgentDistributionQueue;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.apache.sling.jcr.api.SlingRepository;

public class SimpleDistributionAgent
implements DistributionAgent {
    private static final String DEFAULT_AGENT_SERVICE = "defaultAgentService";
    private final DistributionQueueProvider queueProvider;
    private final DistributionPackageImporter distributionPackageImporter;
    private final DistributionPackageExporter distributionPackageExporter;
    private final DistributionQueueDispatchingStrategy scheduleQueueStrategy;
    private final DistributionQueueDispatchingStrategy errorQueueStrategy;
    private final DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy;
    private final DefaultDistributionLog log;
    private final DistributionEventFactory distributionEventFactory;
    private final DistributionQueueProcessor queueProcessor;
    private TriggerAgentRequestHandler agentBasedRequestHandler;
    private final String name;
    private final boolean queueProcessingEnabled;
    private final DistributionRequestType[] allowedRequests;
    private boolean active = false;
    private final Set<String> processingQueues;
    private final String[] allowedRoots;
    private final AtomicInteger nextRequestId = new AtomicInteger();
    private final SimpleDistributionAgentAuthenticationInfo agentAuthenticationInfo;

    public SimpleDistributionAgent(String name, boolean queueProcessingEnabled, Set<String> processingQueues, String subServiceName, DistributionPackageImporter distributionPackageImporter, DistributionPackageExporter distributionPackageExporter, DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy, DistributionQueueProvider queueProvider, DistributionQueueDispatchingStrategy scheduleQueueStrategy, DistributionQueueDispatchingStrategy errorQueueStrategy, DistributionEventFactory distributionEventFactory, ResourceResolverFactory resourceResolverFactory, SlingRepository slingRepository, DefaultDistributionLog log, DistributionRequestType[] allowedRequests, String[] allowedRoots, int retryAttempts) {
        this.log = log;
        this.allowedRequests = allowedRequests;
        this.processingQueues = processingQueues;
        this.validateConfiguration(name, queueProcessingEnabled, subServiceName, distributionPackageImporter, distributionPackageExporter, distributionRequestAuthorizationStrategy, queueProvider, scheduleQueueStrategy, distributionEventFactory, resourceResolverFactory);
        this.allowedRoots = SettingsUtils.removeEmptyEntries(allowedRoots);
        this.distributionRequestAuthorizationStrategy = distributionRequestAuthorizationStrategy;
        this.name = SettingsUtils.removeEmptyEntry(name);
        this.queueProcessingEnabled = queueProcessingEnabled;
        this.distributionPackageImporter = distributionPackageImporter;
        this.distributionPackageExporter = distributionPackageExporter;
        this.queueProvider = queueProvider;
        this.scheduleQueueStrategy = scheduleQueueStrategy;
        this.errorQueueStrategy = errorQueueStrategy;
        this.distributionEventFactory = distributionEventFactory;
        this.agentAuthenticationInfo = new SimpleDistributionAgentAuthenticationInfo(slingRepository, DEFAULT_AGENT_SERVICE, resourceResolverFactory, subServiceName);
        this.queueProcessor = new SimpleDistributionAgentQueueProcessor(distributionPackageExporter, distributionPackageImporter, retryAttempts, errorQueueStrategy, log, queueProvider, distributionEventFactory, this.agentAuthenticationInfo, name);
    }

    private void validateConfiguration(String name, boolean queueProcessingEnabled, String subServiceName, DistributionPackageImporter distributionPackageImporter, DistributionPackageExporter distributionPackageExporter, DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy, DistributionQueueProvider queueProvider, DistributionQueueDispatchingStrategy scheduleQueueStrategy, DistributionEventFactory distributionEventFactory, ResourceResolverFactory resourceResolverFactory) {
        if (name == null || queueProcessingEnabled && distributionPackageImporter == null || distributionPackageExporter == null || distributionRequestAuthorizationStrategy == null || queueProvider == null || scheduleQueueStrategy == null || distributionEventFactory == null || resourceResolverFactory == null) {
            String errorMessage = Arrays.toString(new Object[]{name, distributionPackageImporter, distributionPackageExporter, subServiceName, distributionRequestAuthorizationStrategy, queueProvider, scheduleQueueStrategy, distributionEventFactory, resourceResolverFactory});
            throw new IllegalArgumentException("all arguments are required: " + errorMessage);
        }
    }

    @Override
    @Nonnull
    public DistributionResponse execute(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest) throws DistributionException {
        ResourceResolver agentResourceResolver = null;
        String requestId = "DSTRQ" + this.nextRequestId.incrementAndGet();
        String callingUser = resourceResolver.getUserID();
        try {
            if (!this.isAcceptedRequestType(distributionRequest)) {
                this.log.debug("request type not accepted {}", distributionRequest.getRequestType());
                SimpleDistributionResponse simpleDistributionResponse = new SimpleDistributionResponse(DistributionRequestState.DROPPED, "Request type not accepted");
                return simpleDistributionResponse;
            }
            if (!this.isAcceptedRequestRoot(distributionRequest)) {
                this.log.debug("request paths not accepted {}", Arrays.toString(distributionRequest.getPaths()));
                SimpleDistributionResponse simpleDistributionResponse = new SimpleDistributionResponse(DistributionRequestState.DROPPED, "Request paths not accepted");
                return simpleDistributionResponse;
            }
            boolean silent = DistributionRequestType.PULL.equals((Object)distributionRequest.getRequestType());
            this.log.info(silent, "REQUEST-START {}: {} paths={}, user={}", requestId, distributionRequest.getRequestType(), distributionRequest.getPaths(), callingUser);
            this.distributionRequestAuthorizationStrategy.checkPermission(resourceResolver, distributionRequest);
            agentResourceResolver = DistributionUtils.getResourceResolver(callingUser, this.agentAuthenticationInfo.getAgentService(), this.agentAuthenticationInfo.getSlingRepository(), this.agentAuthenticationInfo.getSubServiceName(), this.agentAuthenticationInfo.getResourceResolverFactory());
            CompositeDistributionResponse distributionResponse = this.exportPackages(agentResourceResolver, distributionRequest, callingUser, requestId);
            this.log.debug("REQUEST-STARTED {}: {} paths={}, success={}, state={}, exportTime={}ms, noPackages={}, size={}B, noQueues={}", requestId, distributionRequest.getRequestType(), distributionRequest.getPaths(), distributionResponse.isSuccessful(), distributionResponse.getState(), distributionResponse.getExportTime(), distributionResponse.getPackagesCount(), distributionResponse.getPackagseSize(), distributionResponse.getQueuesCount());
            CompositeDistributionResponse compositeDistributionResponse = distributionResponse;
            DistributionUtils.ungetResourceResolver(agentResourceResolver);
            return compositeDistributionResponse;
        }
        catch (DistributionException e) {
            this.log.error("REQUEST-FAIL {}: {} paths={}, user={}, message={}", requestId, distributionRequest.getRequestType(), distributionRequest.getPaths(), callingUser, e.getMessage());
            throw e;
        }
        finally {
            DistributionUtils.ungetResourceResolver(agentResourceResolver);
        }
    }

    private boolean isPassive() {
        return !this.queueProcessingEnabled;
    }

    private CompositeDistributionResponse exportPackages(ResourceResolver agentResourceResolver, DistributionRequest distributionRequest, String callingUser, String requestId) throws DistributionException {
        long startTime = System.currentTimeMillis();
        DistributionPackageProcessor packageProcessor = DistributionRequestType.TEST.equals((Object)distributionRequest.getRequestType()) ? new ImportingDistributionPackageProcessor(this.distributionPackageImporter, this.agentAuthenticationInfo, callingUser, requestId, this.log) : new QueueingDistributionPackageProcessor(callingUser, requestId, startTime, this.distributionEventFactory, this.scheduleQueueStrategy, this.queueProvider, this.log, this.name);
        this.distributionPackageExporter.exportPackages(agentResourceResolver, distributionRequest, packageProcessor);
        long endTime = System.currentTimeMillis();
        this.generatePackageEvent("org/apache/sling/distribution/agent/package/created", new DistributionPackage[0]);
        List<DistributionResponse> distributionResponses = packageProcessor.getAllResponses();
        int packagesCount = packageProcessor.getPackagesCount();
        long packagesSize = packageProcessor.getPackagesSize();
        return new CompositeDistributionResponse(distributionResponses, packagesCount, packagesSize, endTime - startTime);
    }

    @Nonnull
    public Set<String> getQueueNames() {
        TreeSet<String> queueNames = new TreeSet<String>();
        queueNames.addAll(this.scheduleQueueStrategy.getQueueNames());
        if (this.errorQueueStrategy != null) {
            queueNames.addAll(this.errorQueueStrategy.getQueueNames());
        }
        return queueNames;
    }

    @Override
    public DistributionQueue getQueue(@Nonnull String queueName) {
        Iterable queues = this.getQueueNames();
        if (!queues.contains(queueName)) {
            return null;
        }
        DistributionQueue queue = null;
        try {
            queue = this.queueProvider.getQueue(queueName);
        }
        catch (DistributionException e) {
            this.log.error("cannot get queue", e);
        }
        if (queue != null) {
            boolean isPausedQueue = !this.queueProcessingEnabled && this.processingQueues != null && this.processingQueues.contains(queueName);
            queue = new SimpleAgentDistributionQueue(queue, isPausedQueue, this.name);
        }
        return queue;
    }

    @Override
    @Nonnull
    public DistributionLog getLog() {
        return this.log;
    }

    @Override
    @Nonnull
    public DistributionAgentState getState() {
        DistributionAgentState agentState = DistributionAgentState.IDLE;
        if (this.isPassive() && this.distributionPackageImporter != null) {
            return DistributionAgentState.PAUSED;
        }
        for (String queueName : this.getQueueNames()) {
            DistributionQueue queue = this.getQueue(queueName);
            DistributionQueueState state = queue.getStatus().getState();
            if (DistributionQueueState.BLOCKED == state) {
                return DistributionAgentState.BLOCKED;
            }
            if (DistributionQueueState.RUNNING != state) continue;
            agentState = DistributionAgentState.RUNNING;
        }
        return agentState;
    }

    public void enable() {
        this.log.info("enabling agent", new Object[0]);
        this.active = true;
        this.agentBasedRequestHandler = new TriggerAgentRequestHandler(this, this.agentAuthenticationInfo, this.log, this.active);
        if (!this.isPassive()) {
            try {
                this.queueProvider.enableQueueProcessing(this.queueProcessor, this.processingQueues.toArray(new String[this.processingQueues.size()]));
            }
            catch (DistributionException e) {
                this.log.error("cannot enable queue processing", e);
            }
        }
    }

    public void enableTrigger(DistributionTrigger trigger) {
        if (!this.active || this.agentBasedRequestHandler == null) {
            return;
        }
        try {
            this.log.info("enabling trigger {}", trigger);
            trigger.register(this.agentBasedRequestHandler);
        }
        catch (DistributionException e) {
            this.log.error("could not register handler from trigger {} {}", trigger, e);
        }
    }

    public void disableTrigger(DistributionTrigger trigger) {
        if (!this.active || this.agentBasedRequestHandler == null) {
            return;
        }
        try {
            this.log.info("disabling trigger {}", trigger);
            trigger.unregister(this.agentBasedRequestHandler);
        }
        catch (DistributionException e) {
            this.log.error("could not unregister handler from trigger {} {}", trigger, e);
        }
    }

    public void disable() {
        this.log.info("disabling agent", new Object[0]);
        this.active = false;
        this.agentBasedRequestHandler = null;
        if (!this.isPassive()) {
            try {
                this.queueProvider.disableQueueProcessing();
            }
            catch (DistributionException e) {
                this.log.error("cannot disable queue processing", e);
            }
        }
    }

    private void generatePackageEvent(String topic, DistributionPackage ... distributionPackages) {
        for (DistributionPackage distributionPackage : distributionPackages) {
            this.distributionEventFactory.generatePackageEvent(topic, DistributionComponentKind.AGENT, this.name, distributionPackage.getInfo());
        }
    }

    private boolean isAcceptedRequestType(DistributionRequest request) {
        if (this.allowedRequests == null) {
            return true;
        }
        if (DistributionRequestType.TEST.equals((Object)request.getRequestType())) {
            return true;
        }
        for (DistributionRequestType requestType : this.allowedRequests) {
            if (!requestType.equals((Object)request.getRequestType())) continue;
            return true;
        }
        return false;
    }

    private boolean isAcceptedRequestRoot(DistributionRequest request) {
        if (this.allowedRoots == null || this.allowedRoots.length == 0) {
            return true;
        }
        if (!DistributionRequestType.ADD.equals((Object)request.getRequestType()) && !DistributionRequestType.DELETE.equals((Object)request.getRequestType())) {
            return true;
        }
        for (String path : request.getPaths()) {
            boolean allowed = false;
            for (String allowedRoot : this.allowedRoots) {
                if (allowedRoot == null || allowedRoot.trim().length() == 0 || !path.startsWith(allowedRoot)) continue;
                allowed = true;
            }
            if (allowed) continue;
            return false;
        }
        return true;
    }
}

