/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.PrivilegeDistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.common.DistributionException;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Request Authorization - Privilege Request Authorization Strategy", description="OSGi configuration for request based authorization strategy based on privileges", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE, immediate=true)
@Service(value={DistributionRequestAuthorizationStrategy.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Strategy name: {name}"})
public class PrivilegeDistributionRequestAuthorizationStrategyFactory
implements DistributionRequestAuthorizationStrategy {
    @Property(label="Name")
    public static final String NAME = "name";
    @Property(label="Jcr Privilege", description="Jcr privilege to check for authorizing distribution requests. The privilege is checked for the calling user session.")
    private static final String JCR_PRIVILEGE = "jcrPrivilege";
    private DistributionRequestAuthorizationStrategy authorizationStrategy;

    @Activate
    public void activate(BundleContext context, Map<String, Object> config) {
        String jcrPrivilege = PropertiesUtil.toString((Object)config.get(JCR_PRIVILEGE), null);
        this.authorizationStrategy = new PrivilegeDistributionRequestAuthorizationStrategy(jcrPrivilege);
    }

    @Override
    public void checkPermission(@Nonnull ResourceResolver resourceResolver, @Nonnull DistributionRequest distributionRequest) throws DistributionException {
        this.authorizationStrategy.checkPermission(resourceResolver, distributionRequest);
    }
}

