/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.DistributionAgent;
import org.apache.sling.distribution.agent.impl.AbstractDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.monitor.impl.ForwardDistributionAgentMBean;
import org.apache.sling.distribution.monitor.impl.ForwardDistributionAgentMBeanImpl;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionQueueProvider;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporter;
import org.apache.sling.distribution.queue.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.AsyncDeliveryDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.ErrorQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.MultipleQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.PriorityQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingDistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.simple.SimpleDistributionQueueProvider;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

@Component(metatype=true, label="Apache Sling Distribution Agent - Forward Agents Factory", description="OSGi configuration factory for forward agents", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Reference(name="triggers", referenceInterface=DistributionTrigger.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindDistributionTrigger", unbind="unbindDistributionTrigger")
@Property(name="webconsole.configurationFactory.nameHint", value={"Agent name: {name}"})
public class ForwardDistributionAgentFactory
extends AbstractDistributionAgentFactory<ForwardDistributionAgentMBean> {
    @Property(label="Name", description="The name of the agent.")
    public static final String NAME = "name";
    @Property(label="Title", description="The display friendly title of the agent.")
    public static final String TITLE = "title";
    @Property(label="Details", description="The display friendly details of the agent.")
    public static final String DETAILS = "details";
    @Property(boolValue={true}, label="Enabled", description="Whether or not to start the distribution agent.")
    private static final String ENABLED = "enabled";
    @Property(label="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
    private static final String SERVICE_NAME = "serviceName";
    @Property(options={@PropertyOption(name="debug", value="debug"), @PropertyOption(name="info", value="info"), @PropertyOption(name="warn", value="warn"), @PropertyOption(name="error", value="error")}, value={"info"}, label="Log Level", description="The log level recorded in the transient log accessible via http.")
    public static final String LOG_LEVEL = "log.level";
    @Property(cardinality=100, label="Allowed roots", description="If set the agent will allow only distribution requests under the specified roots.")
    private static final String ALLOWED_ROOTS = "allowed.roots";
    @Property(boolValue={true}, label="Queue Processing Enabled", description="Whether or not the distribution agent should process packages in the queues.")
    private static final String QUEUE_PROCESSING_ENABLED = "queue.processing.enabled";
    @Property(cardinality=100, label="Importer Endpoints", description="List of endpoints to which packages are sent (imported). The list can be given as a map in case a queue should be configured for each endpoint, e.g. queueName=http://...")
    private static final String IMPORTER_ENDPOINTS = "packageImporter.endpoints";
    @Property(cardinality=100, label="Passive queues", description="List of queues that should be disabled.These queues will gather all the packages until they are removed explicitly.")
    private static final String PASSIVE_QUEUES = "passiveQueues";
    @Property(cardinality=100, label="Priority queues", description="List of priority queues that should used for specific paths.The selector format is  {queuePrefix}[|{mainQueueMatcher}]={pathMatcher}, e.g. french=/content/fr.*")
    private static final String PRIORITY_QUEUES = "priorityQueues";
    @Property(options={@PropertyOption(name="none", value="none"), @PropertyOption(name="errorQueue", value="errorQueue")}, value={"none"}, label="Retry Strategy", description="The strategy to apply after a certain number of failed retries.")
    private static final String RETRY_STRATEGY = "retry.strategy";
    @Property(intValue={100}, label="Retry attempts", description="The number of times to retry until the retry strategy is applied.")
    private static final String RETRY_ATTEMPTS = "retry.attempts";
    @Property(name="requestAuthorizationStrategy.target", label="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="requestAuthorizationStrategy")
    private DistributionRequestAuthorizationStrategy requestAuthorizationStrategy;
    @Property(name="transportSecretProvider.target", label="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    @Property(name="packageBuilder.target", label="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Property(value={"(name=)"}, label="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
    public static final String TRIGGERS_TARGET = "triggers.target";
    @Property(options={@PropertyOption(name="jobs", value="Sling Jobs"), @PropertyOption(name="simple", value="In-memory"), @PropertyOption(name="simple-checkpoint", value="In-file")}, value={"jobs"}, label="Queue provider", description="The queue provider implementation.")
    public static final String QUEUE_PROVIDER = "queue.provider";
    @Property(boolValue={false}, label="Async delivery", description="Whether or not to use a separate delivery queue to maximize transport throughput when queue has more than 100 items")
    public static final String ASYNC_DELIVERY = "async.delivery";
    @Property(label="HTTP connection timeout", intValue={10}, description="The connection timeout for HTTP requests (in seconds).")
    public static final String HTTP = "http.conn.timeout";
    @Reference
    private Packaging packaging;
    @Reference
    private DistributionEventFactory distributionEventFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository slingRepository;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ConfigurationAdmin configAdmin;

    public ForwardDistributionAgentFactory() {
        super(ForwardDistributionAgentMBean.class);
    }

    @Override
    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        super.activate(context, config);
    }

    @Override
    protected void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.bindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    protected void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.unbindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext context) {
        super.deactivate(context);
    }

    @Override
    protected SimpleDistributionAgent createAgent(String agentName, BundleContext context, Map<String, Object> config, DefaultDistributionLog distributionLog) {
        DistributionQueueDispatchingStrategy exportQueueStrategy;
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        String[] allowedRoots = PropertiesUtil.toStringArray((Object)config.get(ALLOWED_ROOTS), null);
        allowedRoots = SettingsUtils.removeEmptyEntries(allowedRoots);
        boolean queueProcessingEnabled = PropertiesUtil.toBoolean((Object)config.get(QUEUE_PROCESSING_ENABLED), (boolean)true);
        String[] passiveQueues = PropertiesUtil.toStringArray((Object)config.get(PASSIVE_QUEUES), (String[])new String[0]);
        passiveQueues = SettingsUtils.removeEmptyEntries(passiveQueues, new String[0]);
        Map<String, String> priorityQueues = PropertiesUtil.toMap((Object)config.get(PRIORITY_QUEUES), (String[])new String[0]);
        priorityQueues = SettingsUtils.removeEmptyEntries(priorityQueues);
        Integer timeout = PropertiesUtil.toInteger((Object)HTTP, (int)10) * 1000;
        HttpConfiguration httpConfiguration = new HttpConfiguration(timeout);
        LocalDistributionPackageExporter packageExporter = new LocalDistributionPackageExporter(this.packageBuilder);
        String queueProviderName = PropertiesUtil.toString((Object)config.get(QUEUE_PROVIDER), (String)"jobs");
        DistributionQueueProvider queueProvider = "jobs".equals(queueProviderName) ? new JobHandlingDistributionQueueProvider(agentName, this.jobManager, context, this.configAdmin) : ("simple".equals(queueProviderName) ? new SimpleDistributionQueueProvider(this.scheduler, agentName, false) : new SimpleDistributionQueueProvider(this.scheduler, agentName, true));
        queueProvider = new MonitoringDistributionQueueProvider(queueProvider, context);
        ErrorQueueDispatchingStrategy errorQueueStrategy = null;
        Map<String, String> importerEndpointsMap = SettingsUtils.toUriMap(config.get(IMPORTER_ENDPOINTS));
        HashSet<String> processingQueues = new HashSet<String>();
        Set<String> endpointNames = importerEndpointsMap.keySet();
        TreeSet<String> endpointsAndPassiveQueues = new TreeSet<String>();
        endpointsAndPassiveQueues.addAll(endpointNames);
        endpointsAndPassiveQueues.addAll(Arrays.asList(passiveQueues));
        String[] queueNames = endpointsAndPassiveQueues.toArray(new String[endpointsAndPassiveQueues.size()]);
        if (priorityQueues != null) {
            PriorityQueueDispatchingStrategy dispatchingStrategy = new PriorityQueueDispatchingStrategy(priorityQueues, queueNames);
            Map<String, String> queueAliases = dispatchingStrategy.getMatchingQueues(null);
            importerEndpointsMap = SettingsUtils.expandUriMap(importerEndpointsMap, queueAliases);
            exportQueueStrategy = dispatchingStrategy;
            endpointNames = importerEndpointsMap.keySet();
        } else {
            boolean asyncDelivery = PropertiesUtil.toBoolean((Object)config.get(ASYNC_DELIVERY), (boolean)false);
            if (asyncDelivery) {
                HashMap<String, String> deliveryQueues = new HashMap<String, String>();
                for (String e : endpointNames) {
                    deliveryQueues.put(e, "delivery-" + e);
                }
                processingQueues.addAll(deliveryQueues.values());
                exportQueueStrategy = new AsyncDeliveryDispatchingStrategy(deliveryQueues);
            } else {
                exportQueueStrategy = new MultipleQueueDispatchingStrategy(endpointNames.toArray(new String[endpointNames.size()]));
            }
        }
        processingQueues.addAll(endpointNames);
        processingQueues.removeAll(Arrays.asList(passiveQueues));
        RemoteDistributionPackageImporter packageImporter = new RemoteDistributionPackageImporter(distributionLog, this.transportSecretProvider, importerEndpointsMap, httpConfiguration);
        DistributionRequestType[] allowedRequests = new DistributionRequestType[]{DistributionRequestType.ADD, DistributionRequestType.DELETE};
        String retryStrategy = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(RETRY_STRATEGY), null));
        int retryAttepts = PropertiesUtil.toInteger((Object)config.get(RETRY_ATTEMPTS), (int)100);
        if ("errorQueue".equals(retryStrategy)) {
            errorQueueStrategy = new ErrorQueueDispatchingStrategy(processingQueues.toArray(new String[processingQueues.size()]));
        }
        return new SimpleDistributionAgent(agentName, queueProcessingEnabled, processingQueues, serviceName, packageImporter, packageExporter, this.requestAuthorizationStrategy, queueProvider, exportQueueStrategy, errorQueueStrategy, this.distributionEventFactory, this.resourceResolverFactory, this.slingRepository, distributionLog, allowedRequests, allowedRoots, retryAttepts);
    }

    @Override
    protected ForwardDistributionAgentMBean createMBeanAgent(DistributionAgent agent, Map<String, Object> osgiConfiguration) {
        return new ForwardDistributionAgentMBeanImpl(agent, osgiConfiguration);
    }

    protected void bindRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy) {
        this.requestAuthorizationStrategy = distributionRequestAuthorizationStrategy;
    }

    protected void unbindRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy) {
        if (this.requestAuthorizationStrategy == distributionRequestAuthorizationStrategy) {
            this.requestAuthorizationStrategy = null;
        }
    }

    protected void bindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        this.transportSecretProvider = distributionTransportSecretProvider;
    }

    protected void unbindTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider) {
        if (this.transportSecretProvider == distributionTransportSecretProvider) {
            this.transportSecretProvider = null;
        }
    }

    protected void bindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        this.packageBuilder = distributionPackageBuilder;
    }

    protected void unbindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        if (this.packageBuilder == distributionPackageBuilder) {
            this.packageBuilder = null;
        }
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindDistributionEventFactory(DistributionEventFactory distributionEventFactory) {
        this.distributionEventFactory = distributionEventFactory;
    }

    protected void unbindDistributionEventFactory(DistributionEventFactory distributionEventFactory) {
        if (this.distributionEventFactory == distributionEventFactory) {
            this.distributionEventFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }
}

