/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.cluster;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptor;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.oak.Config;
import org.apache.sling.discovery.oak.cluster.ClusterReader;
import org.apache.sling.discovery.oak.cluster.InstanceInfo;
import org.apache.sling.discovery.oak.cluster.InstanceReadResult;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ClusterViewService.class})
public class OakClusterViewService
implements ClusterViewService {
    private static final String PROPERTY_CLUSTER_ID = "clusterId";
    private static final String PROPERTY_CLUSTER_ID_DEFINED_AT = "clusterIdDefinedAt";
    private static final String PROPERTY_CLUSTER_ID_DEFINED_BY = "clusterIdDefinedBy";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;
    @Reference
    private IdMapService idMapService;
    private long lastSeqNum = -1L;
    private long lowestSeqNum = -1L;
    private long partialStartupSuppressingTimeout = 0L;
    private Map<Integer, InstanceInfo> seenLocalInstances = new HashMap<Integer, InstanceInfo>();
    private final LogSilencer logSilencer = new LogSilencer(this.logger);

    public static OakClusterViewService testConstructor(SlingSettingsService settingsService, ResourceResolverFactory resourceResolverFactory, IdMapService idMapService, Config config) {
        OakClusterViewService service = new OakClusterViewService();
        service.settingsService = settingsService;
        service.resourceResolverFactory = resourceResolverFactory;
        service.config = config;
        service.idMapService = idMapService;
        service.activate();
        return service;
    }

    @Activate
    public void activate() {
        String suppressPartiallyStartedInstances = this.config == null ? "unknown" : String.valueOf(this.config.getSuppressPartiallyStartedInstances());
        this.logger.info("activate: suppressPartiallyStartedInstances = " + suppressPartiallyStartedInstances);
    }

    public String getSlingId() {
        if (this.settingsService == null) {
            return null;
        }
        return this.settingsService.getSlingId();
    }

    protected ResourceResolver getResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    public LocalClusterView getLocalClusterView() throws UndefinedClusterViewException {
        this.logger.trace("getLocalClusterView: start");
        ResourceResolver resourceResolver = null;
        try {
            DiscoveryLiteDescriptor descriptor = null;
            try {
                resourceResolver = this.getResourceResolver();
                descriptor = DiscoveryLiteDescriptor.getDescriptorFrom((ResourceResolver)resourceResolver);
            }
            catch (Exception e) {
                this.logger.warn("getLocalClusterView: got Exception (enable debug logging to see stacktrace) : " + e);
                this.logger.debug("getLocalClusterView: Exception stacktrace", (Throwable)e);
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "Exception while processing descriptor: " + e);
            }
            if (this.lastSeqNum != descriptor.getSeqNum()) {
                this.logger.info("getLocalClusterView: sequence number change detected - clearing idmap cache");
                this.idMapService.clearCache();
                this.lastSeqNum = descriptor.getSeqNum();
            }
            LocalClusterView localClusterView = this.asClusterView(descriptor, resourceResolver);
            return localClusterView;
        }
        catch (UndefinedClusterViewException e) {
            this.logger.info("getLocalClusterView: undefined clusterView: " + e.getReason() + " - " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger.error("getLocalClusterView: repository exception: " + e, (Throwable)e);
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "Exception while processing descriptor: " + e);
        }
        finally {
            this.logger.trace("getLocalClusterView: end");
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private boolean isSyncTokenEnabled() {
        return this.config != null && this.config.getSyncTokenEnabled();
    }

    private boolean isPartialSuppressionEnabled() {
        return this.config != null && this.config.getSuppressPartiallyStartedInstances();
    }

    private LocalClusterView asClusterView(DiscoveryLiteDescriptor descriptor, ResourceResolver resourceResolver) throws Exception {
        List<Integer> sortedIds;
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null");
        }
        if (resourceResolver == null) {
            throw new IllegalArgumentException("resourceResolver must not be null");
        }
        this.logger.trace("asClusterView: start");
        String clusterViewId = descriptor.getViewId();
        if (clusterViewId == null || clusterViewId.length() == 0) {
            this.logger.trace("asClusterView: no clusterId provided by discovery-lite descriptor - reading from repo.");
            clusterViewId = this.readOrDefineClusterId(resourceResolver);
        }
        long seqNum = descriptor.getSeqNum();
        String localClusterSyncTokenId = String.valueOf(seqNum);
        if (!descriptor.isFinal()) {
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "descriptor is not yet final: " + descriptor);
        }
        LocalClusterView cluster = new LocalClusterView(clusterViewId, localClusterSyncTokenId);
        int me = descriptor.getMyId();
        int[] activeIds = descriptor.getActiveIds();
        if (activeIds == null || activeIds.length == 0) {
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "Descriptor contained no active ids: " + descriptor.getDescriptorStr());
        }
        List activeIdsList = Arrays.stream(activeIds).boxed().collect(Collectors.toList());
        ClusterReader reader = new ClusterReader(resourceResolver, this.config, this.idMapService, this.seenLocalInstances);
        HashMap<Integer, InstanceInfo> regularInstances = new HashMap<Integer, InstanceInfo>();
        HashSet<Integer> partiallyStartedClusterNodeIds = new HashSet<Integer>();
        boolean suppressionEnabled = this.isSyncTokenEnabled() && this.isPartialSuppressionEnabled();
        InstanceReadResult myInstanceResult = reader.readInstance(me, false, -1L);
        InstanceInfo myInstance = myInstanceResult.getInstanceInfo();
        if (myInstance == null) {
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, myInstanceResult.getErrorMsg());
        }
        if (this.partialStartupSuppressingTimeout > 0L && this.partialStartupSuppressingTimeout < System.currentTimeMillis()) {
            suppressionEnabled = false;
        }
        if (!suppressionEnabled || !myInstance.isSyncTokenNewerOrEqual(this.lowestSeqNum)) {
            suppressionEnabled = false;
        }
        for (Integer id : activeIdsList) {
            if (id == me) {
                regularInstances.put(me, myInstance);
                continue;
            }
            InstanceReadResult readResult = reader.readInstance(id, suppressionEnabled, seqNum);
            InstanceInfo instanceInfo = readResult.getInstanceInfo();
            if (instanceInfo == null && !suppressionEnabled) {
                this.idMapService.clearCache();
                readResult = reader.readInstance(id, suppressionEnabled, seqNum);
                instanceInfo = readResult.getInstanceInfo();
            }
            if (instanceInfo == null) {
                if (suppressionEnabled) {
                    partiallyStartedClusterNodeIds.add(id);
                    continue;
                }
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, readResult.getErrorMsg());
            }
            regularInstances.put(id, instanceInfo);
        }
        if (!partiallyStartedClusterNodeIds.isEmpty()) {
            this.logSilencer.infoOrDebug("asClusterView : partial instances : " + partiallyStartedClusterNodeIds);
            activeIdsList.removeAll(partiallyStartedClusterNodeIds);
        }
        if ((sortedIds = this.leaderElectionSort(regularInstances)).size() != activeIdsList.size()) {
            this.logger.error("asClusterView : list size mismatch : sorted = " + sortedIds.size() + ", active = " + activeIdsList.size() + " (partial = " + partiallyStartedClusterNodeIds.size() + ")");
        }
        boolean seenAllSyncTokens = true;
        for (int i = 0; i < sortedIds.size(); ++i) {
            String slingId;
            int id = sortedIds.get(i);
            boolean isLeader = i == 0;
            boolean isOwn = id == me;
            InstanceInfo in = (InstanceInfo)regularInstances.get(id);
            String string = slingId = in == null ? null : in.getSlingId();
            if (slingId == null) {
                this.idMapService.clearCache();
                this.logger.info("asClusterView: cannot resolve oak-clusterNodeId {} to a slingId", (Object)id);
                throw new Exception("Cannot resolve oak-clusterNodeId " + id + " to a slingId");
            }
            if (!in.isSyncTokenNewerOrEqual(seqNum)) {
                this.logSilencer.infoOrDebug("Not seen syncToken (" + seqNum + ") of this instance yet : " + in);
                seenAllSyncTokens = false;
            }
            Map<String, String> properties = this.readProperties(slingId, resourceResolver);
            new DefaultInstanceDescription((DefaultClusterView)cluster, isLeader, isOwn, slingId, properties);
        }
        if (!partiallyStartedClusterNodeIds.isEmpty()) {
            this.logSilencer.infoOrDebug("asClusterView: partially started instance nearby - clearing idmap cache");
            this.idMapService.clearCache();
        } else if (!seenAllSyncTokens) {
            this.logSilencer.infoOrDebug("asClusterView: not seen all syncTokens yet - clearing idmap cache");
            this.idMapService.clearCache();
        }
        if (!partiallyStartedClusterNodeIds.isEmpty()) {
            this.logSilencer.infoOrDebug("asClusterView : adding as partially started slingIds: clusterNodeIds = " + partiallyStartedClusterNodeIds);
            cluster.setPartiallyStartedClusterNodeIds(partiallyStartedClusterNodeIds);
        } else {
            this.logSilencer.reset();
        }
        this.logger.trace("asClusterView: returning {}", (Object)cluster);
        InstanceDescription local = cluster.getLocalInstance();
        if (local == null) {
            this.logger.info("getClusterView: the local instance (" + this.getSlingId() + ") is currently not included in the existing established view! " + "This is normal at startup. At other times is pseudo-network-partitioning is an indicator for repository/network-delays or clocks-out-of-sync (SLING-3432). " + "(increasing the heartbeatTimeout can help as a workaround too) " + "The local instance will stay in TOPOLOGY_CHANGING or pre _INIT mode until a new vote was successful.");
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY, "established view does not include local instance - isolated");
        }
        if (this.lowestSeqNum == -1L) {
            this.lowestSeqNum = seqNum;
        }
        for (InstanceInfo aSeenInstance : this.seenLocalInstances.values()) {
            int clusterNodeId;
            InstanceInfo r = (InstanceInfo)regularInstances.get(aSeenInstance.getClusterNodeId());
            if (r != null || !activeIdsList.contains(clusterNodeId = aSeenInstance.getClusterNodeId())) continue;
            this.logger.error("asClusterView : an instance is unexpectedly no longer part of the view : " + aSeenInstance);
        }
        this.seenLocalInstances = regularInstances;
        if (partiallyStartedClusterNodeIds.isEmpty()) {
            this.partialStartupSuppressingTimeout = 0L;
        } else if (this.partialStartupSuppressingTimeout == 0L) {
            long suppressionTimeoutSeconds = this.config.getSuppressionTimeoutSeconds();
            this.partialStartupSuppressingTimeout = suppressionTimeoutSeconds <= 0L ? 0L : System.currentTimeMillis() + suppressionTimeoutSeconds * 1000L;
        }
        return cluster;
    }

    private List<Integer> leaderElectionSort(Map<Integer, InstanceInfo> resultingInstances) {
        HashMap<Integer, String> leaderElectionIds = new HashMap<Integer, String>();
        for (InstanceInfo i : resultingInstances.values()) {
            leaderElectionIds.put(i.getClusterNodeId(), i.getLeaderElectionId());
        }
        LinkedList<Integer> sortedIds = new LinkedList<Integer>(resultingInstances.keySet());
        this.leaderElectionSort(sortedIds, leaderElectionIds);
        return sortedIds;
    }

    private void leaderElectionSort(List<Integer> activeIdsList, final Map<Integer, String> leaderElectionIds) {
        Comparator<Integer> comparator = this.config.isInvertLeaderElectionPrefixOrder() ? new Comparator<Integer>(){

            private long prefixOf(String leaderElectionId) {
                int underScore = leaderElectionId.indexOf("_");
                if (underScore == -1) {
                    return -1L;
                }
                String prefixStr = leaderElectionId.substring(0, underScore);
                try {
                    return Long.parseLong(prefixStr);
                }
                catch (Exception e) {
                    return -1L;
                }
            }

            @Override
            public int compare(Integer arg0, Integer arg1) {
                long prefix1;
                String leaderElectionId0 = (String)leaderElectionIds.get(arg0);
                String leaderElectionId1 = (String)leaderElectionIds.get(arg1);
                long prefix0 = this.prefixOf(leaderElectionId0);
                if (prefix0 == (prefix1 = this.prefixOf(leaderElectionId1))) {
                    return leaderElectionId0.compareTo(leaderElectionId1);
                }
                return Long.valueOf(prefix1).compareTo(prefix0);
            }
        } : new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((String)leaderElectionIds.get(arg0)).compareTo((String)leaderElectionIds.get(arg1));
            }
        };
        Collections.sort(activeIdsList, comparator);
    }

    private String readOrDefineClusterId(ResourceResolver resourceResolver) throws PersistenceException {
        String clusterInstancesPath = this.config.getClusterInstancesPath();
        String discoveryResourcePath = clusterInstancesPath.substring(0, clusterInstancesPath.lastIndexOf("/", clusterInstancesPath.length() - 2));
        int MAX_RETRIES = 5;
        for (int retryCnt = 0; retryCnt < 5; ++retryCnt) {
            String clusterId;
            Resource varDiscoveryOak = resourceResolver.getResource(discoveryResourcePath);
            if (varDiscoveryOak == null) {
                varDiscoveryOak = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)discoveryResourcePath);
            }
            if (varDiscoveryOak == null) {
                this.logger.error("readOrDefinedClusterId: Could not create: " + discoveryResourcePath);
                throw new RuntimeException("could not create " + discoveryResourcePath);
            }
            ModifiableValueMap props = (ModifiableValueMap)varDiscoveryOak.adaptTo(ModifiableValueMap.class);
            if (props == null) {
                this.logger.error("readOrDefineClusterId: Could not adaptTo ModifiableValueMap: " + varDiscoveryOak);
                throw new RuntimeException("could not adaptTo ModifiableValueMap: " + varDiscoveryOak);
            }
            Object clusterIdObj = props.get((Object)PROPERTY_CLUSTER_ID);
            String string = clusterId = clusterIdObj == null ? null : String.valueOf(clusterIdObj);
            if (clusterId != null && clusterId.length() > 0) {
                this.logger.trace("readOrDefineClusterId: read clusterId from repo as {}", (Object)clusterId);
                return clusterId;
            }
            String newClusterId = UUID.randomUUID().toString();
            props.put((Object)PROPERTY_CLUSTER_ID, (Object)newClusterId);
            props.put((Object)PROPERTY_CLUSTER_ID_DEFINED_BY, (Object)this.getSlingId());
            props.put((Object)PROPERTY_CLUSTER_ID_DEFINED_AT, (Object)Calendar.getInstance());
            try {
                this.logger.info("readOrDefineClusterId: storing new clusterId as " + newClusterId);
                resourceResolver.commit();
                return newClusterId;
            }
            catch (PersistenceException e) {
                this.logger.warn("readOrDefineClusterId: could not persist clusterId (retrying in 1 sec max " + (5 - retryCnt - 1) + " more times: " + (Object)((Object)e), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.logger.warn("readOrDefineClusterId: got interrupted: " + e1, (Throwable)e1);
                }
                this.logger.info("readOrDefineClusterId: retrying now.");
                continue;
            }
        }
        throw new RuntimeException("failed to write new clusterId (see log file earlier for more details)");
    }

    private Map<String, String> readProperties(String slingId, ResourceResolver resourceResolver) {
        ValueMap properties;
        Resource propertiesChild;
        Resource res = resourceResolver.getResource(this.config.getClusterInstancesPath() + "/" + slingId);
        HashMap<String, String> props = new HashMap<String, String>();
        if (res != null && (propertiesChild = res.getChild("properties")) != null && (properties = (ValueMap)propertiesChild.adaptTo(ValueMap.class)) != null) {
            for (String key : properties.keySet()) {
                if (key.equals("jcr:primaryType")) continue;
                props.put(key, (String)properties.get(key, String.class));
            }
        }
        return props;
    }
}

