/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.apache.sling.discovery.oak.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialStartupDetector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolver resourceResolver;
    private final Config config;
    private final int me;
    private final long currentSeqNum;
    private final boolean syncTokenEnabled;
    private final boolean suppressingApplicable;
    private final Set<Integer> partiallyStartedClusterNodeIds = new HashSet<Integer>();
    private final LogSilencer logSilencer;

    PartialStartupDetector(ResourceResolver resourceResolver, Config config, long lowestLocalSeqNum, int me, String mySlingId, long currentSeqNum, long timeoutMillis, LogSilencer logSilencer) {
        this.resourceResolver = resourceResolver;
        this.config = config;
        this.me = me;
        this.currentSeqNum = currentSeqNum;
        this.syncTokenEnabled = config != null && config.getSyncTokenEnabled();
        long now = System.currentTimeMillis();
        long mySyncToken = this.readSyncToken(resourceResolver, mySlingId);
        boolean suppressionConfigured = config != null && config.getSuppressPartiallyStartedInstances();
        boolean bl = this.suppressingApplicable = suppressionConfigured && (timeoutMillis <= 0L || now < timeoutMillis) && mySyncToken != -1L && lowestLocalSeqNum != -1L && mySyncToken >= lowestLocalSeqNum;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<init> suppressionConfigured = " + suppressionConfigured + ", me = " + me + ", mySlingId = " + mySlingId + ", timeoutMillis = " + timeoutMillis + ", mySyncToken = " + mySyncToken + ", lowestLocalSeqNum = " + lowestLocalSeqNum + ", suppressingApplicable = " + this.suppressingApplicable);
        }
        this.logSilencer = logSilencer;
    }

    private boolean isSuppressible(int id) {
        return this.suppressingApplicable && id != this.me;
    }

    private long readSyncToken(ResourceResolver resourceResolver, String slingId) {
        if (slingId == null) {
            throw new IllegalStateException("slingId must not be null");
        }
        Resource syncTokenNode = resourceResolver.getResource(this.config.getSyncTokenPath());
        if (syncTokenNode == null) {
            return -1L;
        }
        ValueMap resourceMap = (ValueMap)syncTokenNode.adaptTo(ValueMap.class);
        if (resourceMap == null) {
            return -1L;
        }
        String syncTokenStr = (String)resourceMap.get(slingId, String.class);
        if (syncTokenStr == null) {
            return -1L;
        }
        try {
            return Long.parseLong(syncTokenStr);
        }
        catch (NumberFormatException nfe) {
            this.logger.warn("readSyncToken: unparsable (non long) syncToken: " + syncTokenStr);
            return -1L;
        }
    }

    boolean suppressMissingIdMap(int id) {
        if (!this.isSuppressible(id)) {
            return false;
        }
        this.partiallyStartedClusterNodeIds.add(id);
        this.logSilencer.infoOrDebug("suppressMissingIdMap-" + id, "suppressMissingIdMap: ignoring partially started clusterNode without idMap entry (in " + this.config.getIdMapPath() + ") : " + id);
        return true;
    }

    boolean suppressMissingSyncToken(int id, String slingId) {
        if (!this.syncTokenEnabled || !this.isSuppressible(id)) {
            return false;
        }
        long syncToken = this.readSyncToken(this.resourceResolver, slingId);
        if (syncToken != -1L && syncToken >= this.currentSeqNum) {
            return false;
        }
        this.partiallyStartedClusterNodeIds.add(id);
        this.logSilencer.infoOrDebug("suppressMissingSyncToken-" + slingId, "suppressMissingSyncToken: ignoring partially started clusterNode without valid syncToken (in " + this.config.getSyncTokenPath() + "/" + slingId + ") : id=" + id + " (expected at least: currentSyncToken=" + this.currentSeqNum + ", is: syncToken=" + syncToken + ")");
        return true;
    }

    boolean suppressMissingLeaderElectionId(int id) {
        if (!this.isSuppressible(id)) {
            return false;
        }
        this.partiallyStartedClusterNodeIds.add(id);
        this.logSilencer.infoOrDebug("suppressMissingLeaderElectionId-" + id, "suppressMissingLeaderElectionId: ignoring partially started clusterNode without leaderElectionId (in " + this.config.getClusterInstancesPath() + ") : " + id);
        return true;
    }

    Collection<Integer> getPartiallyStartedClusterNodeIds() {
        return this.partiallyStartedClusterNodeIds;
    }
}

