/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Apache Sling Discovery Oak Synchronized Clocks Health Check")
@Properties(value={@Property(name="hc.name", value={"Synchronized Clocks"}, description="Health Check name", label="Name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY, description="Health Check tags", label="Tags"), @Property(name="hc.mbean.name", value={"slingDiscoveryOakSynchronizedClocks"}, description="Health Check MBean name", label="MBean name")})
@Service(value={HealthCheck.class})
public class SynchronizedClocksHealthCheck
implements HealthCheck {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DOCUMENT_NODE_STORE_MBEAN = "org.apache.jackrabbit.oak:name=*,type=DocumentNodeStore";
    private static final String TIME_DIFF_METHOD_NAME = "determineServerTimeDifferenceMillis";
    private static final long INTRA_CLUSTER_HIGH_WATER_MARK = 5000L;
    private static final long INTRA_CLUSTER_LOW_WATER_MARK = 1000L;
    private static final long INTER_CLUSTER_HIGH_WATER_MARK = 10000L;
    private static final long INTER_CLUSTER_LOW_WATER_MARK = 5000L;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private SlingSettingsService settingsService;

    public Result execute() {
        String slingId;
        FormattingResultLog resultLog = new FormattingResultLog();
        resultLog.debug("Checking cluster internal clocks", new Object[0]);
        try {
            MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName n = new ObjectName(DOCUMENT_NODE_STORE_MBEAN);
            Set<ObjectName> names = jmxServer.queryNames(n, null);
            if (names.size() == 0) {
                resultLog.info("Intra-cluster test n/a (No DocumentNodeStore MBean found)", new Object[0]);
            } else {
                ObjectName firstName = names.iterator().next();
                Object value = jmxServer.invoke(firstName, TIME_DIFF_METHOD_NAME, new Object[0], new String[0]);
                this.logger.debug("{} returns {}", new Object[]{firstName, TIME_DIFF_METHOD_NAME, value});
                resultLog.debug("{} returns {}", new Object[]{firstName, TIME_DIFF_METHOD_NAME, value});
                if (value != null && value instanceof Long) {
                    Long diffMillis = (Long)value;
                    if (Math.abs(diffMillis) >= 5000L) {
                        this.logger.warn("execute: clocks in local cluster out of sync by {}ms which is equal or higher than the high-water mark of {}ms.", (Object)diffMillis, (Object)5000L);
                        resultLog.critical("Clocks heavily out of sync in local cluster: time difference of this VM with DocumentStore server: {}ms is equal or larger than high-water mark of {}ms", new Object[]{diffMillis, 5000L});
                    } else if (Math.abs(diffMillis) >= 1000L) {
                        this.logger.warn("execute: clocks in local cluster out of sync by {}msms which is equal or higher than the low-water mark of {}ms.", (Object)diffMillis, (Object)1000L);
                        resultLog.warn("Clocks noticeably out of sync in local cluster: time difference of this VM with DocumentStore server: {}ms is equal or larger than low-water mark of {}ms", new Object[]{diffMillis, 1000L});
                    } else {
                        this.logger.debug("execute: clocks in local cluster in sync. diff is {}msms which is within low-water mark of {}ms.", (Object)diffMillis, (Object)1000L);
                        resultLog.info("Clocks in sync in local cluster: time difference of this VM with DocumentStore server: {}ms is within low-water mark of {}ms", new Object[]{diffMillis, 1000L});
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("execute: {}, JMX method {} invocation failed: {}", new Object[]{DOCUMENT_NODE_STORE_MBEAN, TIME_DIFF_METHOD_NAME, e});
            resultLog.healthCheckError("{}, JMX method {} invocation failed: {}", new Object[]{DOCUMENT_NODE_STORE_MBEAN, TIME_DIFF_METHOD_NAME, e});
        }
        String string = slingId = this.settingsService == null ? "n/a" : this.settingsService.getSlingId();
        if (this.announcementRegistry == null) {
            this.logger.warn("execute: no announcementRegistry ({}) set", (Object)this.announcementRegistry);
            resultLog.warn("Cannot determine topology clocks since no announcementRegistry ({}) set", new Object[]{this.announcementRegistry});
        } else {
            Collection localAnnouncements = this.announcementRegistry.listLocalAnnouncements();
            if (localAnnouncements.isEmpty()) {
                this.logger.debug("execute: no topology connectors connected to local instance.");
                resultLog.info("No topology connectors connected to local instance.", new Object[0]);
            }
            for (Announcement ann : localAnnouncements) {
                long receivedAt;
                String peerSlingId = ann.getOwnerId();
                long originallyCreatedAt = ann.getOriginallyCreatedAt();
                long diffMillis = Math.abs(originallyCreatedAt - (receivedAt = ann.getReceivedAt()));
                if (Math.abs(diffMillis) >= 10000L) {
                    this.logger.warn("execute: clocks between local instance (slingId: {}) and remote instance (slingId: {}) out of sync by {}msms which is equal or higher than the high-water mark of {}ms.", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
                    resultLog.critical("Clocks heavily out of sync between local instance (slingId: {}) and remote instance (slingId: {}): by {}ms which is equal or larger than high-water mark of {}ms", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
                    continue;
                }
                if (Math.abs(diffMillis) >= 5000L) {
                    this.logger.warn("execute: clocks out of sync between local instance (slingId: {}) and remote instance (slingId: {}) by {}ms ms which is equal or higher than the low-water mark of {}ms.", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
                    resultLog.warn("Clocks noticeably out of sync between local instance (slingId: {}) and remote instance (slingId: {}): by {}ms which is equal or larger than low-water mark of {}ms", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
                    continue;
                }
                this.logger.debug("execute: clocks in sync between local instance (slingId: {}) and remote instance (slingId: {}). diff is {}ms which is within low-water mark of {}ms.", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
                resultLog.info("Clocks in sync between local instance (slingId: {}) and remote instance (slingId: {}): diff is {}ms which is within low-water mark of {}ms", new Object[]{slingId, peerSlingId, diffMillis, 10000L});
            }
        }
        return new Result((ResultLog)resultLog);
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

